from __future__ import print_function
import os

from crypta.lib.python.yql_runner.base_parser import BaseParser, timer, make_arg_parser


class PrepareRadiusSoup(BaseParser):

    """ Run YQL query to parse fp sources """

    # input directories
    MATCHING_DIR = '//home/crypta/production/state/graph/v2/matching'
    RADIUS_TABLE = '//home/crypta/production/state/radius/metrics/%s/yuid_rlogin/yuid_rlogin_final_stable'
    # output directories
    OUTPUT_DIR = '//home/crypta/production/state/graph/v2/soup/cooked/radius'

    QUERY_TEMLATE = 'query.sql.j2'

    def get_dirs(self):
        """ Get current environ and replace directories path to env """
        dirs = super(PrepareRadiusSoup, self).get_dirs()
        dirs.update(
            matching_dir=self.MATCHING_DIR,
            radius_table=self.RADIUS_TABLE % self.date,
        )
        return dirs


@timer
def main():
    parser = make_arg_parser(description='Prepare soup in Radius yandexuid area')
    args = parser.parse_args()

    task = PrepareRadiusSoup(
        date=args.date,
        yt_proxy=args.cluster,
        pool=args.pool,
        mrjob_binary=os.path.abspath(args.mrjob),
        udf_resolver_binary=os.path.abspath(args.udfr),
        udfs_dir=os.path.abspath(args.udfsdir),
        loglevel=args.loglevel,
        limit=args.limit,
    )
    assert task.get_token(), 'Env variable YT_TOKEN required!'
    if os.environ.get('VERBOSE'):
        print(task.render_query())
    return task.run()


if __name__ == '__main__':
    main()
