USE hahn;

PRAGMA SimpleColumns;

$radius_table = '{{ radius_table }}';
$matching_dir = '{{ matching_dir }}';

$vertices_to_crypta_id_table = $matching_dir || '/vertices_no_multi_profile';
$vertices_properties_by_crypta_id_table = $matching_dir || '/vertices_properties_by_crypta_id';
$edges_by_crypta_id_table = $matching_dir || '/edges_by_crypta_id';
$component_neighbours_table = $matching_dir || '/crypta_components_neighbours';
$edges_between_components = $matching_dir || '/edges_between_components';

$out_dir = '{{ output_dir }}';
$out_vp_table = $out_dir || '/vertices_properties';
$out_edges_table = $out_dir || '/edges';

-- filtering ids
$ids = (
    SELECT WeakField(yuid, "String") as id, 'yandexuid' as id_type
    from $radius_table
);

$affected_crypta_ids = (
    SELECT
        ccId,
        ccIdType
    FROM $vertices_to_crypta_id_table as a
    INNER JOIN
    $ids as ids
    using (id, id_type)
);

-- select * from $affected_crypta_ids;

$affected_crypta_id_neighbours =
(
    SELECT
        Yson::ConvertToString(neighbour.ccId) as ccId,
        Yson::ConvertToString(neighbour.ccIdType) as ccIdType
    FROM (
        SELECT
            Yson::ConvertToList(b.neighbours) as neighbours
        FROM $affected_crypta_ids AS ccIds
        INNER JOIN $component_neighbours_table as b
        USING (ccId, ccIdType)
) FLATTEN LIST BY neighbours AS neighbour);

-- select * from $affected_crypta_id_neighbours;

$all_cc_ids = (
    select distinct ccId, ccIdType
    from (
        SELECT ccId, ccIdType
        FROM $affected_crypta_ids

        UNION ALL

        SELECT ccId, ccIdType
        FROM $affected_crypta_id_neighbours
    )
);

-- select * from $all_cc_ids;

$mini_vertices_properties = (
    SELECT * FROM
        $vertices_properties_by_crypta_id_table AS vertices_properties
    INNER JOIN
        $all_cc_ids AS all_cc_ids
    using (ccId, ccIdType)
);


insert into $out_vp_table WITH TRUNCATE
SELECT *
FROM $mini_vertices_properties
ORDER BY id, id_type;


$affected_edges_in_components = (
    SELECT
        *
    FROM
        $edges_by_crypta_id_table AS edges_by_crypta_id
    INNER JOIN
        $all_cc_ids AS all_cc_ids
    USING (ccId, ccIdType)
);

$affected_edges_between_components = (
SELECT
    edges.*
FROM $affected_crypta_ids AS ccIds
INNER JOIN $edges_between_components as edges
USING (ccId, ccIdType));

$mini_soup_edges = (
    select *
    from (
        SELECT id1, id1Type, id2, id2Type, logSource, sourceType, ccId, ccIdType, dates
        FROM $affected_edges_in_components

        UNION ALL

        SELECT id1, id1Type, id2, id2Type, logSource, sourceType, ccId, ccIdType, dates
        FROM $affected_edges_between_components
    )
);

INSERT INTO $out_edges_table WITH TRUNCATE
SELECT *
FROM $mini_soup_edges
ORDER BY id1Type, id2Type, id1, id2;
