from __future__ import print_function

import os
import argparse
import sys
import yt.wrapper as yt

from crypta.lib.python.yql_runner.base_parser import BaseParser

YT_PROXY = os.environ.get('YT_PROXY')
YT_TOKEN = os.environ.get('YT_TOKEN')
YT_POOL = os.environ.get('YT_POOL')


class SoupostatParser(BaseParser):
    QUERY_TEMPLATE = 'query.sql.j2'

    def __init__(self, cc_table, soup_stats_table):
        super(SoupostatParser, self).__init__(date=None,
                                              yt_proxy=YT_PROXY,
                                              pool=YT_POOL,
                                              is_embedded=False)
        self.cc_table = cc_table
        self.soup_stats_table = soup_stats_table

    def get_context_data(self):
        return super(SoupostatParser, self).get_context_data(
            cc_table=self.cc_table,
            soup_stats_table=self.soup_stats_table)


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--date', required=True)
    args = parser.parse_args()
    return args


def main():
    cc_table_path = '//home/crypta/production/state/graph/v2/soup_cc/components'
    soup_stats_path = '//home/crypta/production/state/graph/v2/soup_stats'
    args = parse_args()

    try:
        yql_task = SoupostatParser(cc_table=cc_table_path, soup_stats_table=soup_stats_path)
        yql_task.run()

        yt.config.set_proxy(YT_PROXY)
        yt.config.token = YT_TOKEN
        yt.config.pool = YT_POOL

        yt.set_attribute(soup_stats_path, 'generate_date', args.date)
    except Exception as e:
        print(str(e), file=sys.stderr)
        raise


if __name__ == 'main':
    main()
