USE hahn;
PRAGMA yt.InferSchema;

$cc = (
    SELECT * FROM `{{ cc_table }}`
);

$stats = (
    SELECT
        component_id,
        count_if(id_type == 'email') AS emails,
        count_if(id_type == 'idfa' OR id_type == 'gaid' OR id_type == 'mm_device_id') AS devices,
        count_if(id_type == 'login') AS logins,
        count_if(id_type == 'phone') AS phones,
        count_if(id_type == 'vk_id') AS vks,
        count_if(id_type == 'ok_id') AS oks,
        count(id) AS vertices
    FROM $cc
    GROUP BY component_id
);

INSERT INTO `{{ soup_stats_table }}`
WITH TRUNCATE
SELECT *
FROM $stats;

SELECT
    devices,
    emails,
    vertices,
    logins,
    phones,
    vks,
    oks,
    count(distinct component_id) as times,
FROM $stats
GROUP BY emails, devices, logins, phones, vks, oks, vertices;

