from crypta.graph.soupy_indevice.lib.util import run_yql, timed


@timed
def calculate_link_counts(pairs, output, tx):
    run_yql('''
        PRAGMA SimpleColumns;
        PRAGMA yt.ExternalTx = '{tx}';

        $pairs = '{pairs}';

        $double_soup = (
            select distinct id1, id1Type, id2, id2Type from (
                select id1, id1Type, id2, id2Type from $pairs
                union all
                select id1 as id2, id1Type as id2Type, id2 as id1, id2Type as id1Type from $pairs
            )
        );

        $link_counts = (
            select id1, id1Type, id2Type, count(*) as c
            from $double_soup
            group by id1, id1Type, id2Type
        );

        insert into `{output}` with truncate
        select * from $link_counts;
    '''.format(
        pairs=pairs,
        output=output,
        tx=tx.transaction_id
    ))


@timed
def calculate_link_count_percentiles(link_counts, output, tx):
    run_yql('''
        pragma SimpleColumns;
        pragma yt.ExternalTx = '{tx}';

        $link_count_perc = (
            select
                id1Type,
                id2Type,
                cast(max(c) as uint64) as p100,
                cast(Math::Ceil(percentile(c, 0.99999)) as uint64) as p99999,
                cast(Math::Ceil(percentile(c, 0.9999)) as uint64) as p9999,
                cast(Math::Ceil(percentile(c, 0.999)) as uint64) as p999,
                cast(Math::Ceil(percentile(c, 0.99)) as uint64) as p99,
                cast(Math::Ceil(percentile(c, 0.95)) as uint64) as p95,
                cast(Math::Ceil(percentile(c, 0.75)) as uint64) as p75,
                cast(Math::Ceil(percentile(c, 0.50)) as uint64) as p50
            from `{link_counts}`
            group by id1Type, id2Type
        );

        insert into `{output}` with truncate
        select * from $link_count_perc
        order by id1Type, id2Type;
    '''.format(
        link_counts=link_counts,
        output=output,
        tx=tx.transaction_id
    ))
