import datetime

from reactor_client.reactor_api import ReactorAPIClientV1
import reactor_client.reactor_objects as r_objects

from library.python.step.client import Client, DEFAULT_HOSTS

from crypta.graph.soupy_indevice.lib import config


class FakeClient(object):
    def __init__(*args, **kwargs):
        pass

    def create_event(self, name, params):
        print "STEP event: name={}, params={}".format(name, params)

    @property
    def artifact_instance(self):
        print "REACTOR artifact_instance"
        return self

    def instantiate(self, *args, **kwargs):
        print "REACTOR instantiate {args} {kwargs}".format(args=args, kwargs=kwargs)


def mkclient_step():
    if config.ENVIRONMENT in ["stable"]:
        env = "production" if config.ENVIRONMENT == "stable" else config.ENVIRONMENT
        return Client(host=DEFAULT_HOSTS[env], token=config.STATBOX_STEP_TOKEN)
    else:
        return FakeClient()


def mkclient_reactor():
    if config.ENVIRONMENT in ["stable"]:
        return ReactorAPIClientV1(base_url="https://reactor.yandex-team.ru", token=config.REACTOR_TOKEN)
    else:
        return FakeClient()


def _send_event_step(dtstr, path, cluster, typ="crypta", group="crypta-indevice"):
    client = mkclient_step()

    event = {
        "type": typ,
        "group": group,
        "scale": "1d",
        "path": path,
        "timestamp": "{}T00:00:00".format(dtstr),
        "cluster": cluster,
    }
    client.create_event(name="cluster_table_publish", params=event)


def _send_event_reactor(dtstr, table_path, cluster, namespace_path):
    client = mkclient_reactor()
    artifact_id = r_objects.ArtifactIdentifier(
        namespace_identifier=r_objects.NamespaceIdentifier(namespace_path=namespace_path)
    )

    client.artifact_instance.instantiate(
        artifact_identifier=artifact_id,
        metadata=r_objects.Metadata(
            type_="/yandex.reactor.artifact.YtPathArtifactValueProto",
            dict_obj={"cluster": cluster, "path": table_path},
        ),
        user_time=datetime.datetime.strptime(dtstr, "%Y-%m-%d"),
    )


def send_indevice_ready_event(dtstr, cluster, kind=None):
    if kind is None:
        kind = "full"
    path = "home/crypta/public/indevice/{kind}".format(kind=kind)
    table_path = "//{path}/{dtstr}".format(path=path, dtstr=dtstr)
    namespace_path = "/yt/{cluster}/{path}".format(cluster=cluster, path=path)
    group = "crypta-indevice-{}".format(kind)

    _send_event_step(dtstr, table_path, cluster, "crypta", group)
    _send_event_reactor(dtstr, table_path, cluster, namespace_path)
