import logging
import os
import sys
import time

from crypta.graph.soupy_indevice.lib import config
from crypta.lib.python.yql_runner.runner import YqlRunner


logger = logging.getLogger(__name__)


def setup_logging():
    logging.basicConfig(format="%(asctime)-15s %(name)s %(message)s")

    root = logging.getLogger()
    root.setLevel(logging.INFO)

    logging.getLogger("luigi").setLevel(logging.INFO)
    logging.getLogger("luigi-interface").setLevel(logging.INFO)

    handler = logging.StreamHandler(sys.stdout)
    handler.setLevel(logging.INFO)

    formatter = logging.Formatter("%(asctime)-15s %(name)s %(levelname)s %(message)s")
    handler.setFormatter(formatter)

    for h in root.handlers:
        root.removeHandler(h)

    root.addHandler(handler)


def get_file(variants):
    for f in variants:
        if ";" in f:
            # special case for test, check udf colon splitted dir
            return f
        if os.path.exists(f):
            return f
    raise Exception("None of %s exist!" % variants)


def run_yql(query):
    mrjob = get_file([config.MRJOB_PATH, "../../../../yql/tools/mrjob/mrjob"])
    udfr = get_file([config.UDF_RESOLVER_PATH, "../../../../yql/tools/udf_resolver/udf_resolver"])
    udfs = get_file([config.UDFS_DIR, "../../../../yql/udfs"])

    # try to speed up indevice
    query = (
        """
        PRAGMA yt.DataSizePerSortJob = "3G";
        PRAGMA yt.DefaultMemoryLimit = "4G";
    """
        + query
    )

    task = YqlRunner(
        yt_proxy=config.YT_PROXY,
        pool=config.YT_POOL,
        mrjob_binary=mrjob,
        udf_resolver_binary=udfr,
        udfs_dir=udfs,
        is_embedded=True,
        query=query,
        script_name="soupy_indevice",
    )

    logger.info(task.render_query())

    task.run()

    logger.info("Query plan: {}".format(task.last_op.plan()))


def timed(f):
    def wrapper(*args, **kwargs):
        begin = int(time.time())
        logger.info("Begin {}".format(f.__name__))
        f(*args, **kwargs)
        end = int(time.time())
        logger.info("End {} (took {}s)".format(f.__name__, (end - begin)))

    return wrapper
