# -*- coding: utf-8 -*-
import datetime
import re

import yt.wrapper as yt
from cached_property import cached_property

import crypta.lib.python.bt.conf.conf as conf

redt = re.compile(r"(\d{4}-\d{2}-\d{2})")


def get_table(root, report_date, num=0):
    def _get_date(table):
        match = redt.search(str(table))
        if match:
            return match.group(0)

    tables = sorted([(_get_date(x), x) for x in yt.list(root, absolute=True) if _get_date(x)], reverse=True)

    if report_date == "last":
        return tables[num]
    else:
        if num:
            prev_date = datetime.datetime.strptime(report_date, "%Y-%m-%d") - datetime.timedelta(days=num)
            report_date = prev_date.strftime("%Y-%m-%d")
        return report_date, "{}/{}".format(root, report_date)


class SolomonMixin(object):
    @cached_property
    def solomon_config(self):
        return {"url": conf.proto.SolomonConfig.Url}

    @cached_property
    def solomon_service(self):
        return {
            "project": conf.proto.SolomonService.Project,
            "cluster": conf.proto.SolomonService.Cluster,
            "service": conf.proto.SolomonService.Service,
        }
