# -*- coding: utf-8 -*-
from textwrap import dedent

from crypta.graph.metrics.lib import YqlDailyReportBase, SolomonSensorConfig
from crypta.graph.soupy_indevice.statface.lib.common import get_table, SolomonMixin


class CoverageReport(SolomonMixin, YqlDailyReportBase):

    report_name = 'Crypta/Graph/Indevice/CoverageMetrics'
    indevice_root = '//home/crypta/production/state/graph/v2/indevice'
    idstorage_root = '//home/crypta/production/ids_storage'
    kind = 'default'

    @property
    def query(self):
        dt_indevice, indevice_table = get_table(self.indevice_root, self.report_date)
        appm_month = '{}/device_id/app_metrica_month'.format(self.idstorage_root)
        yuid_month = '{}/yandexuid/yuid_with_all_info'.format(self.idstorage_root)

        return dedent('''
            $indevice = '{indevice}';
            $appm_month = '{appm_month}';
            $yuid_month = '{yuid_month}';

            $russian_ids = (
                select id_type, id from $appm_month where main_region_country = 225
                union all
                select id_type, id from $yuid_month where main_region_country = 225
            );

            $russian_mobile_ids = (
                select id_type, id from $appm_month where main_region_country = 225
                union all
                select id_type, id
                from $yuid_month
                where main_region_country = 225 and String::StartsWith(ua_profile, 'm|')
            );

            $russian_indevice = (
                select a.indevice_id as indevice_id
                from $indevice as a
                inner join $russian_ids as b using (id, id_type)
            );

            $russian_mobile_indevice = (
                select a.indevice_id as indevice_id
                from $indevice as a
                inner join $russian_mobile_ids as b using (id, id_type)
            );

            $distinct_russian_indevice = (
                select distinct indevice_id from $russian_indevice
            );

            $distinct_russian_mobile_indevice = (
                select distinct indevice_id from $russian_mobile_indevice
            );

            $russian_indevice_count = (select count(*) from $distinct_russian_indevice);
            $russian_mobile_indevice_count = (select count(*) from $distinct_russian_mobile_indevice);

            select
                '{date}' as fielddate,
                '{kind}' as kind,
                $russian_indevice_count as russian_indevice_count,
                $russian_mobile_indevice_count as russian_mobile_indevice_count
            ;
        '''.format(
            indevice=indevice_table,
            appm_month=appm_month,
            yuid_month=yuid_month,
            date=dt_indevice,
            kind=self.kind
        ))

    report_config = dedent('''
        ---
        dimensions:
            - fielddate: date
            - kind: string
        measures:
            - russian_indevice_count: number
            - russian_mobile_indevice_count: number
        calculations:
            - russian_nonmobile_indevice_count:
                expression: "russian_indevice_count - russian_mobile_indevice_count"
        graphs:
            - title: 'Количество мобильных indevice_id'
              fields:
                - russian_mobile_indevice_count
    ''')

    solomon_sensors = SolomonSensorConfig(
        sensor_keys=['russian_indevice_count', 'russian_mobile_indevice_count'],
        labels=['kind']
    )
