# -*- coding: utf-8 -*-
from textwrap import dedent

from crypta.graph.metrics.lib import YqlDailyReportBase, SolomonSensorConfig
from crypta.graph.soupy_indevice.statface.lib.common import get_table, SolomonMixin


class StabilityReport(SolomonMixin, YqlDailyReportBase):

    report_name = 'Crypta/Graph/Indevice/Stability'
    indevice_root = '//home/crypta/production/state/graph/v2/indevice'
    kind = 'default'

    @property
    def query(self):
        dt_last, last = get_table(self.indevice_root, self.report_date, 0)
        dt_prev, prev = get_table(self.indevice_root, self.report_date, 1)

        return dedent('''
            $indevice_last = '{indevice_last}';
            $indevice_prev = '{indevice_prev}';

            $stuff = (
                select
                    a.id_type ?? b.id_type as id_type,
                    a.id ?? b.id as id,
                    case
                        when a.indevice_id is not null and b.indevice_id is not null
                            then if(a.indevice_id == b.indevice_id, 'not_changed', 'changed')
                        when a.indevice_id is not null and b.indevice_id is null then 'new'
                        when a.indevice_id is null and b.indevice_id is not null then 'lost'
                        else 'unexpected'
                    end as status
                from $indevice_last as a
                full outer join $indevice_prev as b using (id_type, id)
            );

            $counters = (
                select status, count(*) as cnt
                from $stuff group by status
            );

            $not_changed = (select cnt from $counters where status = 'not_changed');
            $changed = (select cnt from $counters where status = 'changed');
            $new = (select cnt from $counters where status = 'new');
            $lost = (select cnt from $counters where status = 'lost');
            $unexpected = (select cnt from $counters where status = 'unexpected');

            select
                '{date}' as fielddate,
                '{kind}' as kind,
                $not_changed as not_changed,
                $changed as changed,
                $new as new,
                $lost as lost,
                $unexpected as unexpected
            ;
        '''.format(
            indevice_last=last,
            indevice_prev=prev,
            date=dt_last,
            kind=self.kind
        ))

    report_config = dedent('''
        ---
        dimensions:
            - fielddate: date
            - kind: string
        measures:
            - not_changed: number
            - changed: number
            - new: number
            - lost: number
            - unexpected: number
            - total: number
        graphs:
            - title: 'Изменения indevice_id'
              type: 'stacked_100p'
              fields:
                - not_changed
                - changed
                - new
                - lost
                - unexpected
    ''')

    solomon_sensors = SolomonSensorConfig(
        sensor_keys=['not_changed', 'changed', 'new', 'lost', 'unexpected'],
        labels=['kind']
    )
