# -*- coding: utf-8 -*-
import logging
import sys

from crypta.graph.metrics.lib import daily_report_main
import crypta.lib.python.bt.conf.conf as conf
from crypta.lib.python.getoptpb import ParsePbOptions
from crypta.graph.soupy_indevice.statface.proto.config_pb2 import TSoupyIndeviceMetricsConfig
from crypta.graph.soupy_indevice.statface.lib.conflict_metrics import DistMetricsReport
from crypta.graph.soupy_indevice.statface.lib.id_types import IdCountReport
from crypta.graph.soupy_indevice.statface.lib.russia_coverage import CoverageReport
from crypta.graph.soupy_indevice.statface.lib.sizes_coverage import SizesAndTrafficReport
from crypta.graph.soupy_indevice.statface.lib.stability import StabilityReport
from crypta.graph.soupy_indevice.statface.lib.yandex_apps_coverage import YandexAppsCoverage


class StabilityReportFast(StabilityReport):
    indevice_root = '//home/crypta/production/state/graph/v2/indevice/fast'
    kind = 'fast'


class CoverageReportFast(CoverageReport):
    indevice_root = '//home/crypta/production/state/graph/v2/indevice/fast'
    kind = 'fast'


class SizesAndTrafficReportFast(SizesAndTrafficReport):
    indevice_root = '//home/crypta/production/state/graph/v2/indevice/fast'
    kind = 'fast'


class DistMetricsReportFast(DistMetricsReport):
    indevice_root = '//home/crypta/production/state/graph/v2/indevice/fast'
    kind = 'fast'


class YandexAppsCoverageFast(YandexAppsCoverage):
    indevice_root = '//home/crypta/production/state/graph/v2/indevice/fast'
    kind = 'fast'


def main():
    logging.basicConfig(level="INFO")

    if len(sys.argv) > 1 and sys.argv[1] == 'fast':
        del sys.argv[1]
        conf.use_proto(ParsePbOptions(TSoupyIndeviceMetricsConfig))

        daily_report_main(StabilityReportFast)
        daily_report_main(CoverageReportFast)
        daily_report_main(SizesAndTrafficReportFast)
        daily_report_main(DistMetricsReportFast)
        daily_report_main(YandexAppsCoverageFast)
    else:
        conf.use_proto(ParsePbOptions(TSoupyIndeviceMetricsConfig))

        daily_report_main(StabilityReport)
        daily_report_main(SizesAndTrafficReport)
        daily_report_main(CoverageReport)
        daily_report_main(DistMetricsReport)
        daily_report_main(IdCountReport)
        daily_report_main(YandexAppsCoverage)
