import contextlib

import crypta.lib.python.bt.conf.conf as conf  # noqa
from crypta.lib.python.yql_runner.task import YQLRunnerTask
from crypta.graph.staff.lib.staff_exporter import StaffLoader, YtProcessor


class StaffTask(YQLRunnerTask):
    """Dump staff to yt and match with crytpa"""

    @property
    def query_template(self):
        return "staff.sql.j2"

    @contextlib.contextmanager
    def run_context(self):
        self.prepare_dynamic()
        with super(StaffTask, self).run_context() as ctx:
            yield ctx

    def run(self, *args, **kwargs):
        super(StaffTask, self).run(*args, **kwargs)

    def prepare_dynamic(self):
        table_name = "//home/crypta/{crypta_env}/ids_storage/staff/dump".format(crypta_env=self.crypta_env)
        data = StaffLoader().process()
        YtProcessor(self.yt).process_table(data, table_name)

    def requires(self, *args, **kwargs):
        return []
