USE hahn;

$styx_source_dir = '{{styx_source_dir}}';
$last_table_path = '{{last_table_path}}';

$target_full_table_path = '{{target_full_table_path}}';
$target_bb_table_path = '{{target_bb_table_path}}';

$by_id_type_table_path = '{{by_id_type_table_path}}';
$by_crypta_id_table_path = '{{by_crypta_id_table_path}}';

$last_styx_table = (
    SELECT last_table
    FROM $last_table_path
    LIMIT 1
);

$table_name_re = Re2::Capture(@@^.*\/(?P<name>[^\/\.]+).*$@@);
$styx_tables = (
    SELECT AGGREGATE_LIST(Path)
    FROM FOLDER($styx_source_dir, 'row_count')
    WHERE Type == 'table'
        AND Yson::LookupUint64(Attributes, 'row_count') > 0
        AND $table_name_re(`Path`).name > $last_styx_table
);

-- TODO: Request stronger schema
$puids = (
    SELECT
        CAST(Yson::ConvertToUint64(id) AS String) AS id,
        Yson::ConvertToString(id_type) AS id_type
    FROM
        EACH($styx_tables)
);


$cids = (
    SELECT DISTINCT
        cryptaId
    FROM
        $by_id_type_table_path AS by_id
    JOIN
        $puids AS styx
    ON (styx.id_type = by_id.id_type AND styx.id = by_id.id)
);

$expanded = (
    SELECT
        cids.cryptaId as crypta_id,
        id,
        id_type
    FROM
        $cids as cids
    JOIN
        $by_crypta_id_table_path as by_cid
    ON (cids.cryptaId = by_cid.cryptaId)
);

INSERT INTO $target_full_table_path
SELECT crypta_id, id, id_type
FROM $expanded;

INSERT INTO $target_bb_table_path
SELECT crypta_id, id, id_type
FROM $expanded
WHERE id_type IN {
    "duid",
    "gaid",
    "oaid",
    "puid",
    "mm_device_id",
    "idfa",
    "ifv",
    "yandexuid",
    "icookie",
}
;

{% if update_last_table %}
INSERT INTO $last_table_path WITH TRUNCATE
SELECT $table_name_re(ListSortDesc($styx_tables)[0]).name ?? $last_styx_table AS last_table;
{% endif %}
