from __future__ import print_function
import argparse
import logging
import os

from crypta.graph.v1.python import graph_all
from crypta.graph.v1.python import run_postproc
from crypta.graph.v1.python import run_radius
from crypta.graph.v1.python.infra.link_access_logs import link_access_logs
from crypta.graph.v1.python.rtcconf import config
from crypta.graph.v1.python.v2.soup import backup


def enable_logging(level=logging.DEBUG):
    if os.getenv("IS_SANDBOX"):
        file_handler = logging.FileHandler(os.path.join(config.LOG_FOLDER, "crypta-graph-v1.log"))
        file_handler.setLevel(level)

        logger = logging.getLogger()
        logger.setLevel(level)
        logger.addHandler(file_handler)
        logger.info("Start Graph")


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--graph", help="Run main graph process for the specified date (yyyy-mm-dd)")
    parser.add_argument("--graph-task", help="Specify the graph process main luigi task", default="MainTask")
    parser.add_argument("--postproc", action="store_true", help="Run postproc")
    parser.add_argument("--postrock", action="store_true", help="Play postrock")
    parser.add_argument("--radius", help="Run radius import task for the specific date (yyyy-mm-dd)")
    parser.add_argument(
        "--force-yes", action="store_true", help="No ask confirmation on postrock (useful in sandbox task)"
    )
    parser.add_argument(
        "--link-access-logs",
        action="store_true",
        help="Create symlinks for all the access logs to be used by the Skleika",
    )
    parser.add_argument("--soup-backup", action="store_true", help="Make soup backup (to Arnold)")
    parser.add_argument("--debug", action="store_true", default=False, help="Set default log level to DEBUG")

    return parser.parse_args()


def main():
    args = parse_args()
    enable_logging(level=logging.DEBUG if args.debug else logging.INFO)

    if args.graph:
        graph_all.main(args.graph_task, args.graph)
    elif args.radius:
        run_radius.main(args.radius)
    elif args.postproc or args.postrock:
        run_postproc.main(args.force_yes)
    elif args.link_access_logs:
        link_access_logs()
    elif args.soup_backup:
        backup.backup_soup()
    else:
        print("Hello, world")
