#!/usr/bin/env bash

function check_log() {
    log_file=$1
    result_file=$2

    DIR=`dirname $0`
    err_msg=`python ${GRAPH_PY_FOLDER}/tools/upload_logchecker.py ${log_file}`
    if [ "0" == "$?" ]
    then
        echo "0;OK" > ${result_file}
    else
        echo "2;${name} upload failed: ${err_msg}" > ${result_file}
    fi
}

function log {
  echo "$(date) $1"
}

function should_run() {
    RUN='no'
    # NOTE(k-zaitsev): v1 is moving to SB at https://st.yandex-team.ru/CRYPTA-4787
    if [ "${CRYPTA_ENV}" == "testing" ] && [ -n "${CRYPTA_OVERRIDE_RUN:-}" ]; then
        RUN='yes'
    fi

    if [ ${CRYPTA_ENV} == "production" ] && [ ${CRYPTA_DC} == ${CRYPTA_PROD_DC} ] && [ -n "${CRYPTA_OVERRIDE_RUN:-}" ]; then
        RUN='yes'
    fi

    echo "$RUN"
}
