#!/bin/bash -u

set -e -u -o pipefail

DIR=`dirname $0`

source /etc/yandex/rtcrypta-config/set_crypta_env.sh
source ${DIR}/functions.sh

DATE=`date '+%Y-%m-%d_%H:%M'`
export PREV_DATE=`date -d "yesterday 13:00 " '+%Y-%m-%d'`

if [ "$(should_run)" == "no" ]; then
    log "No run"
    exit
fi

# Create logging directories (if they are not exist)
mkdir -p ${RTCRYPTA_PYSTARTER_LOG_FOLDER}luigi
mkdir -p ${RTCRYPTA_PYSTARTER_LOG_FOLDER}yt
mkdir -p ${RTCRYPTA_PYSTARTER_RUN_FOLDER}${DATE}

RUN_TYPE="${@:1:1}"
# v1 vs v2 params
if [ "$RUN_TYPE" == "v1" ]; then
    log "Run v1"
    BINARY_PATH=${RTCRYPTA_PYSTARTER_RUN_FOLDER}${DATE}/crypta-graph-v1
    RUN_PARAMS="--graph $PREV_DATE --graph-task MainV1Task"
    export LUIGI_RUN_TAGS="v1"
    export YT_POOL="crypta_graph_v1"
elif [ "$RUN_TYPE" == "v2" ]; then
    log "Run v2"
    BINARY_PATH=${RTCRYPTA_PYSTARTER_RUN_FOLDER}${DATE}/crypta-graph-v2
    RUN_PARAMS="--graph $PREV_DATE --graph-task MainV2Task"
    export LUIGI_FAIL_TAGS="v1"  # v2 should not depend on v1 tasks
elif [ "$RUN_TYPE" == "all" ]; then
    log "Run all"
    BINARY_PATH=${RTCRYPTA_PYSTARTER_RUN_FOLDER}${DATE}/crypta-graph-vall
    RUN_PARAMS="--graph $PREV_DATE --graph-task MainTask"
else
    log "Specify v1 or v2"
    exit
fi

# Copy scripts to run folder (CRYPTA-1595)

cp /opt/crypta/crypta-graph-v1/crypta-graph-v1 ${BINARY_PATH}

log "START"
log "Running luigi..."
${BINARY_PATH} ${RUN_PARAMS}

log "All OK, self-destroying"
rm -rf ${BINARY_PATH}

log "END"
