import luigi

from crypta.graph.soup.config.python import LOG_SOURCE as log_source

from crypta.graph.v1.python.lib.luigi import yt_luigi
from crypta.graph.v1.python.rtcconf import config
from crypta.graph.v1.python.utils.yql_utils import run_yql
from crypta.graph.v1.python.v2.soup.soup_tables import SoupDailyDumpTable, MobmetPreprocessedDumpTable


class ImportMetrikaUserParams(yt_luigi.BaseYtTask):
    date = luigi.Parameter()

    def __init__(self, *args, **kwargs):
        super(ImportMetrikaUserParams, self).__init__(*args, **kwargs)

        self.soup_metrika_userparams_table = SoupDailyDumpTable(log_source.METRIKA_USERPARAMS, self.date)

    def input_folders(self):
        return {"metrika_dir": config.METRIKA_INPUT_FOLDER}

    def output_folders(self):
        return {"output": self.soup_metrika_userparams_table.table_path()}

    def requires(self):
        return yt_luigi.ExternalInput(self.in_f("metrika_dir") + "/params_01")

    def before_run(self):
        self.soup_metrika_userparams_table.ensure_dir()

    def run(self):
        params = dict(date=self.date, metrika_dir=self.in_f("metrika_dir"), output=self.out_f("output"))
        run_yql("MetrikaUserParamsParser", params)

    def output(self):
        allow_empty = True
        return [yt_luigi.YtTarget(self.out_f("output"), allow_empty=allow_empty)]


class PreprocessMetrikaUserParamsOwners(yt_luigi.BaseYtTask):
    date = luigi.Parameter()

    def __init__(self, *args, **kwargs):
        super(PreprocessMetrikaUserParamsOwners, self).__init__(*args, **kwargs)

        self.output_cross_mobmet_table = MobmetPreprocessedDumpTable(
            "cross_mobmet",
            schema={"CounterID": "uint64", "AppID": "string", "OperatingSystem": "string"},
            date=self.date,
        )
        self.output_params_owners_table = MobmetPreprocessedDumpTable(
            "metrika_params_owners",
            schema={"CounterID": "uint64", "ProfileID": "string", "yandexuid": "string"},
            date=self.date,
        )

    def input_folders(self):
        return {
            "metrika_dir": config.METRIKA_INPUT_FOLDER,
            "mobmet_app_id_and_domains": config.MOBMET_APP_ID_AND_DOMAINS,
            "mobmet_counters_and_domains": config.MOBMET_COUNTERS_AND_DOMAINS,
        }

    def output_folders(self):
        return {
            "output_cross_mobmet": self.output_cross_mobmet_table.table_path(),
            "output_params_owners": self.output_params_owners_table.table_path(),
        }

    def requires(self):
        return [
            yt_luigi.ExternalInput(self.in_f("metrika_dir") + "/param_owners_01"),
            yt_luigi.ExternalInput(self.in_f("mobmet_app_id_and_domains")),
            yt_luigi.ExternalInput(self.in_f("mobmet_counters_and_domains")),
        ]

    def before_run(self):
        self.output_cross_mobmet_table.ensure_dir()

    def run(self):
        params = dict(
            date=self.date,
            metrika_dir=self.in_f("metrika_dir"),
            mobmet_app_id_and_domains=self.in_f("mobmet_app_id_and_domains"),
            mobmet_counters_and_domains=self.in_f("mobmet_counters_and_domains"),
            output_cross_mobmet=self.out_f("output_cross_mobmet"),
            output_params_owners=self.out_f("output_params_owners"),
        )
        run_yql("MobmetPreprocessing", params)

        self.output_cross_mobmet_table.finalize()
        self.output_params_owners_table.finalize()

    def output(self):
        return [
            yt_luigi.YtDateTarget(self.out_f("output_cross_mobmet"), self.date),
            yt_luigi.YtDateTarget(self.out_f("output_params_owners"), self.date),
        ]
