import luigi

from crypta.graph.v1.python.lib.luigi import yt_luigi
from crypta.graph.v1.python.rtcconf import config
from crypta.graph.v1.python.utils.yql_utils import run_yql
from crypta.graph.v1.python.v2.soup import soup_dirs, soup_tables

from crypta.graph.soup.config.python import (
    ID_TYPE as ids,
    SOURCE_TYPE as source_type,
    LOG_SOURCE as log_source,
    EDGE_TYPE as edges,
)


class ImportPassportDump(yt_luigi.BaseYtTask):
    date = luigi.Parameter()

    def __init__(self, *args, **kwargs):
        super(ImportPassportDump, self).__init__(*args, **kwargs)
        self.soup_tables = [
            soup_tables.SoupDumpTable(
                edges.get_edge_type(ids.PUID, ids.LOGIN, source_type.PASSPORT_PROFILE, log_source.PASSPORT_DICT),
                self.date,
            ),
            soup_tables.SoupDumpTable(
                edges.get_edge_type(ids.PUID, ids.PHONE, source_type.PASSPORT_PROFILE, log_source.PASSPORT_PHONE_DUMP),
                self.date,
            ),
        ]

    def input_folders(self):
        return {"userdata": config.PASSPORT_USERDATA}

    def output_folders(self):
        return {"soup_dump": soup_dirs.SOUP_DUMPS_DIR}

    def requires(self):
        return [
            yt_luigi.ExternalInput(self.in_f("userdata") + self.date),
        ]

    def before_run(self):
        for soup in self.soup_tables:
            soup.ensure_dir()

    def run(self):

        with self.yt.Transaction() as tr:
            run_yql(
                "PassportParser",
                params=dict(date=self.date),
                context=dict(
                    userdata_tbl=self.in_f("userdata") + self.date,
                    soup_out_dir=self.out_f("soup_dump").rstrip("/"),
                    transaction_id=tr.transaction_id,
                ),
            )

        for soup in self.soup_tables:
            soup.finalize()

    def output(self):
        return [soup.as_target() for soup in self.soup_tables]
