from functools import partial

import luigi

from crypta.graph.v1.python.lib.luigi import yt_luigi
from crypta.graph.v1.python.rtcconf import config
from crypta.graph.v1.python.utils import yt_clients
from crypta.graph.v1.python.v2.soup.soup_tables import SoupDumpTable

from crypta.graph.soup.config.python import (
    ID_TYPE as ids,
    SOURCE_TYPE as source_type,
    LOG_SOURCE as log_source,
    EDGE_TYPE as edges,
)

from crypta.graph.v1.python.lib.luigi import base_luigi_task


def import_phone_email_dump(rec, edge_type):
    yield SoupDumpTable.make_rec(
        # hashes in fact
        rec["email"],
        rec["phone"],
        edge_type,
        [],
    )


class ImportEmailPhoneDumpsToSoup(base_luigi_task.BaseTask, yt_clients.YtClientMixin):
    date = luigi.Parameter()

    def __init__(self, *args, **kwargs):
        super(ImportEmailPhoneDumpsToSoup, self).__init__(*args, **kwargs)
        self.ezep_dump_et = SoupDumpTable(
            edges.get_edge_type(ids.EMAIL_MD5, ids.PHONE_MD5, source_type.EZEP_DUMP, log_source.EXTERNAL_DUMPS),
            self.date,
        )
        self.victoria_dump_et = SoupDumpTable(
            edges.get_edge_type(ids.EMAIL_MD5, ids.PHONE_MD5, source_type.VICTORIA_DUMP, log_source.EXTERNAL_DUMPS),
            self.date,
        )

        self.dumps = [
            (self.ezep_dump_et, config.GRAPH_YT_DICTS_FOLDER + "external_dumps/ezep_secret_dump"),
            (self.victoria_dump_et, config.GRAPH_YT_DICTS_FOLDER + "external_dumps/viktoria"),
        ]

    def requires(self):
        return [yt_luigi.ExternalInput(i[1]) for i in self.dumps]

    def run(self):
        with self.yt.Transaction() as tr:
            for soup_table, in_table in self.dumps:
                self.yt.run_map(
                    partial(import_phone_email_dump, edge_type=soup_table.edge_type), in_table, soup_table.create(tr)
                )
                soup_table.finalize()

    def output(self):
        return [t[0].as_target() for t in self.dumps]
