from functools import partial

import luigi

from crypta.graph.v1.python.lib.luigi import yt_luigi
from crypta.graph.v1.python.rtcconf import config
from crypta.graph.v1.python.v2.soup.soup_tables import SoupDumpTable

from crypta.graph.soup.config.python import (
    ID_TYPE as ids,
    SOURCE_TYPE as source_type,
    LOG_SOURCE as log_source,
    EDGE_TYPE as edges,
)


def mapper_mail_vkid_puid(rec):
    puid = rec.get("uid", None)
    vk_id = rec.get("vk_id", None)
    if puid and vk_id:
        yield {"puid": puid, "vk_id": vk_id}


def reducer_mail_vkid_puid(keys, _, puid_vkcom_maildump):
    yield SoupDumpTable.make_rec(str(keys["puid"]), str(keys["vk_id"]), puid_vkcom_maildump, [], 0)


class ImportVkidPuidMailDump(yt_luigi.BaseYtTask):
    date = luigi.Parameter()

    def __init__(self, *args, **kwargs):
        super(ImportVkidPuidMailDump, self).__init__(*args, **kwargs)
        self.soup_table = SoupDumpTable(
            edges.get_edge_type(ids.PUID, ids.VK_ID, source_type.MAIL_TEMPLATE, log_source.SHERLOCK), self.date
        )

    def input_folders(self):
        return {"export": config.VKID_PUID_DMP_FOLDER}

    def output_folders(self):
        return {"dict": config.GRAPH_YT_DICTS_FOLDER}

    def output(self):
        return [self.soup_table.as_target()]

    def run(self):
        dump_table = self.in_f("export") + "vk_ids"

        with self.yt.Transaction() as transaction:

            self.yt.run_map_reduce(
                mapper_mail_vkid_puid,
                partial(reducer_mail_vkid_puid, puid_vkcom_maildump=self.soup_table.edge_type),
                dump_table,
                self.soup_table.create(transaction),
                reduce_by=["puid", "vk_id"],
            )

            self.soup_table.finalize()
