import luigi

import yt.wrapper as yt
from crypta.graph.v1.python.data_imports import StreamImportBaseTask
from crypta.graph.v1.python.lib.luigi import yt_luigi
from crypta.graph.v1.python.rtcconf import config
from crypta.graph.v1.python.utils.yql_utils import run_yql
from crypta.graph.v1.python.data_imports.import_logs import rtb_log, postback_log

from crypta.graph.soup.config.python import LOG_SOURCE as log_source  # N811 # noqa


class ImportAppMetrikaDayTask(yt_luigi.BaseYtTask):

    date = luigi.Parameter()
    run_date = luigi.Parameter()
    resources = {"import_app_metrika_lock": 1}
    priority = 1

    def output_folders(self):
        return {
            "mobile": config.YT_OUTPUT_FOLDER + self.date + "/mobile/",
            "fuzzy2": config.INDEVICE_YT_FOLDER + self.date + "/fuzzy/",
        }

    def before_run(self):
        self.yt.mkdir(self.out_f("mobile").rstrip("/"), recursive=True)
        self.yt.mkdir(self.out_f("fuzzy2").rstrip("/"), recursive=True)

    def run(self):
        run_yql("MetricaMonthAggregator", dict(date_start=self.date, date_end=None, is_month=False))

    def output(self):
        tables = [
            yt.ypath.ypath_join(self.out_f("mobile"), "uuid_info_yt"),
            yt.ypath.ypath_join(self.out_f("mobile"), "dev_info_yt"),
            yt.ypath.ypath_join(self.out_f("mobile"), "account_manager/am_log"),
        ]
        return [yt_luigi.YtTarget(table) for table in tables]

    def requires(self):
        yield rtb_log.WaitRtbLogSoup(date=self.date, run_date=self.run_date)
        yield postback_log.WaitPostbackLogSoup(date=self.date, run_date=self.run_date)
        yield WaitMetricaSoup(date=self.date, run_date=self.run_date)


class WaitMetricaSoup(StreamImportBaseTask):

    date = luigi.Parameter()
    run_date = luigi.Parameter()

    observed_logs = [
        "appmetrica-yandex-events",
        "appmetrica-external-events",
        "browser-metrika-mobile-log",
        "superapp-metrika-mobile-log",
    ]

    def __init__(self, *args, **kwargs):
        ls = log_source.METRIKA_MOBILE_LOG
        wait_keys = ["AppMetrikaTask", "SoupTask"]
        super(WaitMetricaSoup, self).__init__(ls, wait_keys, *args, **kwargs)
