import luigi
import yt.wrapper as yt

from crypta.graph.v1.python.lib.luigi import yt_luigi
from crypta.graph.v1.python.rtcconf import config
from crypta.graph.v1.python.utils.yql_utils import run_yql
from crypta.graph.v1.python.v2.soup import soup_dirs
from crypta.graph.v1.python.v2.soup.soup_tables import SoupDailyTable
from crypta.graph.soup.config.python import ID_TYPE as ids, SOURCE_TYPE as source_type, LOG_SOURCE as log_source, Edges


class ImportAutoRuDayTask(yt_luigi.BaseYtTask):
    date = luigi.Parameter()
    run_date = luigi.Parameter()

    def input_folders(self):
        return {
            "autoru_logfeller_logs": yt.ypath.ypath_join(config.AUTORU_INPUT_FOLDER, self.date),
            "autoru_warehouse_logs": yt.ypath.ypath_join(config.AUTORU_WAREHOUSE_FOLDER, self.date),
        }

    def output_folders(self):
        soup_day = soup_dirs.get_day_dir(self.date)

        return {
            "soup_day": soup_day,
            "autoid_mm_device_id": yt.ypath.ypath_join(
                soup_day,
                Edges.title(
                    ids.AUTO_ID.Name, ids.MM_DEVICE_ID.Name, source_type.AUTORU_EVENT_LOG.Name, log_source.AUTORU.Name
                ),
            ),
            "autoid_yandexuid": yt.ypath.ypath_join(
                soup_day,
                Edges.title(
                    ids.AUTO_ID.Name, ids.YANDEXUID.Name, source_type.AUTORU_EVENT_LOG.Name, log_source.AUTORU.Name
                ),
            ),
            "autoid_phone": yt.ypath.ypath_join(
                soup_day,
                Edges.title(
                    ids.AUTO_ID.Name, ids.PHONE.Name, source_type.AUTORU_EVENT_LOG.Name, log_source.AUTORU.Name
                ),
            ),
            "autoid_gaid": yt.ypath.ypath_join(
                soup_day,
                Edges.title(
                    ids.AUTO_ID.Name, ids.GAID.Name, source_type.AUTORU_EVENT_LOG.Name, log_source.AUTORU.Name
                ),
            ),
            "autoid_idfa": yt.ypath.ypath_join(
                soup_day,
                Edges.title(
                    ids.AUTO_ID.Name, ids.IDFA.Name, source_type.AUTORU_EVENT_LOG.Name, log_source.AUTORU.Name
                ),
            ),
            "gaid_mm_device_id": yt.ypath.ypath_join(
                soup_day,
                Edges.title(
                    ids.GAID.Name, ids.MM_DEVICE_ID.Name, source_type.AUTORU_EVENT_LOG.Name, log_source.AUTORU.Name
                ),
            ),
            "idfa_mm_device_id": yt.ypath.ypath_join(
                soup_day,
                Edges.title(
                    ids.IDFA.Name, ids.MM_DEVICE_ID.Name, source_type.AUTORU_EVENT_LOG.Name, log_source.AUTORU.Name
                ),
            ),
        }

    def __init__(self, *args, **kwargs):
        yt_luigi.BaseYtTask.__init__(self, *args, **kwargs)

        self.soup_daily = SoupDailyTable(log_source.AUTORU, self.date)

    def requires(self):
        return [
            yt_luigi.ExternalInput(self.in_f("autoru_logfeller_logs")),
            yt_luigi.ExternalInput(self.in_f("autoru_warehouse_logs")),
        ]

    def before_run(self):
        self.soup_daily.ensure_dir()

    def run(self):
        params = dict(
            date=self.date,
            logfeller_logs=self.in_f("autoru_logfeller_logs"),
            warehouse_logs=self.in_f("autoru_warehouse_logs"),
            autoid_mm_device_id=self.out_f("autoid_mm_device_id"),
            autoid_yandexuid=self.out_f("autoid_yandexuid"),
            autoid_phone=self.out_f("autoid_phone"),
            autoid_gaid=self.out_f("autoid_gaid"),
            autoid_idfa=self.out_f("autoid_idfa"),
            gaid_mm_device_id=self.out_f("gaid_mm_device_id"),
            idfa_mm_device_id=self.out_f("idfa_mm_device_id"),
        )
        run_yql("AutoRuParser", params)

    def output(self):
        allow_empty = config.CRYPTA_ENV != "production"
        return [
            yt_luigi.YtTarget(self.out_f("autoid_mm_device_id"), allow_empty=allow_empty),
            yt_luigi.YtTarget(self.out_f("autoid_yandexuid"), allow_empty=allow_empty),
            yt_luigi.YtTarget(self.out_f("autoid_phone"), allow_empty=allow_empty),
            yt_luigi.YtTarget(self.out_f("autoid_gaid"), allow_empty=allow_empty),
            yt_luigi.YtTarget(self.out_f("autoid_idfa"), allow_empty=allow_empty),
            yt_luigi.YtTarget(self.out_f("gaid_mm_device_id"), allow_empty=allow_empty),
            yt_luigi.YtTarget(self.out_f("idfa_mm_device_id"), allow_empty=allow_empty),
        ]
