import luigi

from crypta.graph.v1.python.lib.luigi import yt_luigi
from crypta.graph.v1.python.rtcconf import config
from crypta.graph.v1.python.v2.soup.soup_tables import SoupDailyLogTable
from crypta.graph.v1.python.utils import utils
from crypta.graph.v1.python.utils import yt_clients

from crypta.graph.soup.config.python import (
    ID_TYPE as ids,
    SOURCE_TYPE as source_type,
    LOG_SOURCE as log_source,
    EDGE_TYPE as edges,
)

from crypta.graph.v1.python.lib.luigi import base_luigi_task


def is_proper_yuid(xuniq):
    return utils.get_yuid_creation_date(xuniq) is not None


def map_bs_xuniqs(rec):
    keyword_edgetypes = {
        154: edges.get_edge_type(ids.YANDEXUID, ids.XUNIQ_GUID, source_type.XUNIQ, log_source.BS_XUNIQS_LOG),
        39: edges.get_edge_type(ids.YANDEXUID, ids.YANDEXUID, source_type.XUNIQ, log_source.BS_XUNIQS_LOG),
        245: edges.get_edge_type(ids.YANDEXUID, ids.UUID, source_type.XUNIQ, log_source.BS_XUNIQS_LOG),
    }

    try:
        kwid = int(rec["pagekeywordid"])
    except (KeyError, ValueError):
        return

    if kwid in keyword_edgetypes:
        yuid = rec["uniqid"]
        xuniq = rec["xuniqid"]
        ts = -int(rec["unixtime"])
        edge_type = keyword_edgetypes[kwid]

        if (kwid != 39) or (kwid == 39 and xuniq != yuid and is_proper_yuid(xuniq)):
            if is_proper_yuid(yuid):
                yield SoupDailyLogTable.make_rec(yuid, xuniq, edge_type, ts)


class ImportBsXuniqsLog(base_luigi_task.BaseTask, yt_clients.YtClientMixin):
    date = luigi.Parameter()
    run_date = luigi.Parameter()

    def __init__(self, *args, **kwargs):
        super(ImportBsXuniqsLog, self).__init__(*args, **kwargs)
        self.soup_log = SoupDailyLogTable(log_source.BS_XUNIQS_LOG, self.date)

    def requires(self):
        return yt_luigi.ExternalInput(self.get_log_table())

    def output(self):
        return self.soup_log.daily_tables_targets()

    def run(self):
        self.soup_log.ensure_dir()
        with self.yt.Transaction():
            soup_tmp_table = self.soup_log.create()
            self.yt.run_map(map_bs_xuniqs, self.get_log_table(), soup_tmp_table)
            self.soup_log.prepare_daily_tables_from_log()

    def get_log_table(self):
        return config.LOG_FOLDERS["bs_xuniqs"] + self.date
