import luigi
import yt.wrapper as yt

from crypta.graph.v1.python.lib.luigi import yt_luigi
from crypta.graph.v1.python.rtcconf import config
from crypta.graph.v1.python.utils.yql_utils import run_yql
from crypta.graph.v1.python.v2.soup import soup_dirs
from crypta.graph.soup.config.python import (  # N811 # noqa
    ID_TYPE as ids,
    SOURCE_TYPE as source_type,
    LOG_SOURCE as log_source,
    Edges,
)


class ImportCheventDayTask(yt_luigi.BaseYtTask):

    """ Parse bs-chevent-log """

    date = luigi.Parameter()
    run_date = luigi.Parameter()

    def __init__(self, *args, **kwargs):
        super(ImportCheventDayTask, self).__init__(*args, **kwargs)
        self.out_edges = [
            Edges.title(ids.YANDEXUID.Name, ids.IDFA.Name, source_type.APP_ADV.Name, log_source.EVENT_LOG.Name),
            Edges.title(ids.YANDEXUID.Name, ids.GAID.Name, source_type.APP_ADV.Name, log_source.EVENT_LOG.Name),
            Edges.title(ids.YANDEXUID.Name, ids.OAID.Name, source_type.APP_ADV.Name, log_source.EVENT_LOG.Name),
            Edges.title(ids.YANDEXUID.Name, ids.IFV.Name, source_type.APP_ADV.Name, log_source.EVENT_LOG.Name),
        ]

    def output_folders(self):
        return {"soup_dir": soup_dirs.get_day_dir(self.date)}

    def input_folders(self):
        return {"chevent_log": config.LOG_FOLDERS["bschevent"]}

    def requires(self):
        return yt_luigi.ExternalInput(self.in_f("chevent_log") + self.date)

    def run(self):
        run_yql("CheventParser", dict(date=self.date))

    def output(self):
        if self.date == self.run_date:
            return [
                yt_luigi.YtTarget(yt.ypath.ypath_join(self.out_f("soup_dir"), edge), allow_empty=False)
                for edge in self.out_edges
            ]
        return []
