import luigi

from crypta.graph.v1.python.data_imports import StreamImportBaseTask

from crypta.graph.soup.config.python import (  # N811 # noqa
    ID_TYPE as ids,
    LOG_SOURCE as log_source,
    SOURCE_TYPE as source_type,
)


class WaitRtbLogSoup(StreamImportBaseTask):
    date = luigi.Parameter()
    run_date = luigi.Parameter()
    observed_logs = ["bs-rtb-log"]

    def __init__(self, *args, **kwargs):
        ls = log_source.BS_RTB_LOG
        wait_keys = ["RTBLogTask", "SoupTask"]
        super(WaitRtbLogSoup, self).__init__(ls, wait_keys, *args, **kwargs)
