import luigi
import yt.wrapper as yt

from crypta.graph.v1.python.lib.luigi import yt_luigi
from crypta.graph.v1.python.rtcconf import config
from crypta.graph.v1.python.utils.yql_utils import run_yql
from crypta.graph.v1.python.v2.soup import soup_dirs
from crypta.graph.v1.python.v2.soup.soup_tables import SoupDailyTable
from crypta.graph.soup.config.python import ID_TYPE as ids, SOURCE_TYPE as source_type, LOG_SOURCE as log_source, Edges


class ImportVisitLogDayTask(yt_luigi.BaseYtTask):
    date = luigi.Parameter()
    run_date = luigi.Parameter()

    def input_folders(self):
        return {
            "visit_log": yt.ypath.ypath_join(config.LOGFELLER_VISIT_V2_LOG_FOLDER, self.date),
            "visit_private_log": yt.ypath.ypath_join(config.LOGFELLER_VISIT_V2_PRIVATE_LOG_FOLDER, self.date),
        }

    def output_folders(self):
        soup_day = soup_dirs.get_day_dir(self.date)

        return {
            "soup_day": soup_day,
            "out_phone_yuid": yt.ypath.ypath_join(
                soup_day,
                Edges.title(
                    ids.PHONE.Name,
                    ids.YANDEXUID.Name,
                    source_type.METRIKA_OFFLINE_CONVERSION.Name,
                    log_source.VISIT_LOG.Name,
                ),
            ),
        }

    def __init__(self, *args, **kwargs):
        yt_luigi.BaseYtTask.__init__(self, *args, **kwargs)

        self.soup_daily = SoupDailyTable(log_source.VISIT_LOG, self.date)

    def requires(self):
        return [yt_luigi.ExternalInput(self.in_f("visit_log")), yt_luigi.ExternalInput(self.in_f("visit_private_log"))]

    def before_run(self):
        self.soup_daily.ensure_dir()

    def run(self):
        params = dict(
            date=self.date,
            visit_log=self.in_f("visit_log"),
            visit_private_log=self.in_f("visit_private_log"),
            out_phone_yuid_soup=self.out_f("out_phone_yuid"),
        )
        run_yql("VisitParser", params)

    def output(self):
        return [yt_luigi.YtTarget(self.out_f("out_phone_yuid"), allow_empty=True)]
