import luigi

from crypta.graph.v1.python.infra import graph_postproc
from crypta.graph.v1.python.lib.luigi.yt_luigi import PostGraphTask
from crypta.graph.v1.python.matching.human_matching.stats.radius import radius_metrics
from crypta.graph.v1.python.rtcconf import config
from crypta.graph.v1.python.utils import utils
from crypta.graph.v1.python.v2 import v2_task_status
from crypta.graph.v1.python.v2 import yuid_apps
from crypta.graph.v1.python.v2.ids_storage.eternal import UpdateEternalIdStorage
from crypta.graph.v1.python.v2.soup.backup import SoupBackupTask


class GraphV2Tasks(luigi.WrapperTask):
    date = luigi.Parameter()

    def requires(self):

        external_stats_data_tasks = [radius_metrics.PrepareYuidRadiusData(self.date)]
        if config.CRYPTA_ENV != "development":
            # no sandbox instance in tests
            external_stats_data_tasks += [yuid_apps.UploadYuidAppsTask(self.date)]

        v2_tasks = [
            v2_task_status.V2IsReadyAll(date=self.date),
            v2_task_status.IndeviceStuffIsReady(date=self.date),
            UpdateEternalIdStorage(date=self.date),
        ]

        # Mobile apps for mobile yuids via puid & indevice links
        other_tasks = [yuid_apps.PrepareUploadYuidAppsTask(date=self.date)]
        if config.CRYPTA_ENV != "development":
            other_tasks += [
                # no sandbox instance in tests
                yuid_apps.UploadYuidAppsTask(self.date)
            ]

        if config.SOUP_BACKUP_ENABLE:
            other_tasks.append(SoupBackupTask(self.date))

        return external_stats_data_tasks + v2_tasks + other_tasks

    def run(self):
        utils.monrun_ok()


class GraphV2PostprocTask(PostGraphTask):
    def __init__(self, date, name="v2"):
        super(GraphV2PostprocTask, self).__init__(date=date, name=name)

    def run_post_graph(self):
        graph_postproc.run_postproc(safe_mode=False, run_date=self.date, clean_v1=True, clean_v2=True)

    def requires(self):
        return GraphV2Tasks(date=self.date)


class MainV2Task(luigi.WrapperTask):
    date = luigi.Parameter()

    def requires(self):
        tasks = [GraphV2Tasks(date=self.date), GraphV2PostprocTask(date=self.date, name="postproc-v2")]

        return tasks
