from __future__ import print_function
import argparse
# import functools
import sys
from datetime import datetime, timedelta

import yt.wrapper as yt

from crypta.graph.v1.python.rtcconf import config
from crypta.graph.v1.python.v2.soup.graph_soup_update import add_day_to_soup_python
from crypta.graph.v1.python.v2.soup.soup_tables import SoupDailyTable

# from crypta.graph.soup.config.python import SOURCE_TYPE as source_type, LOG_SOURCE as log_source, EDGE_TYPE as edges


if "__main__" == __name__:
    """
    This is a script that can import logs from specified time period into the soup.
    Useful when where's a new source, or when there's been a mistake and we need to reimport.
    This is so that we don't have to run ad-hoc YQL or Python to achieve the above things,
    and instead runs the same tasks used for imports during normal operation.
    """
    argp = argparse.ArgumentParser()
    argp.add_argument("--begin", nargs=1)
    argp.add_argument("--end", nargs=1)
    argp.add_argument("--type", nargs=1)

    args = argp.parse_args()

    begin = datetime.strptime(args.begin[0], "%Y-%m-%d")
    end = datetime.strptime(args.end[0], "%Y-%m-%d")

    importers = {
        # "log-source-name": functools.partial(ImportLog, log_source=log_source.***)
    }

    edge_types = {
        # "log-source-name": [
        #     et for et in edges.values() if et.SourceType == source_type.*** and et.LogSource == log_source.***
        # ]
    }

    importer = importers.get(args.type[0])
    if importer is None:
        print('Expected one of "%s" for type' % ", ".join(importers))
        sys.exit(1)

    edges = edge_types[args.type[0]]

    yt.config.set_proxy(config.MR_SERVER)
    yt.config["tabular_data_format"] = yt.YsonFormat(control_attributes_mode="row_fields")
    yt.config.INTERMEDIATE_DATA_ACCOUNT = "crypta"

    tables = set()
    dt = begin
    while dt <= end:
        dtstr = dt.strftime("%Y-%m-%d")
        imp = importer(date=dtstr, run_date=dtstr)
        imp.run()
        tables |= set([SoupDailyTable(et, dtstr) for et in edges])
        dt = dt + timedelta(days=1)

    add_day_to_soup_python(args.end[0], tables)
