import os

from crypta.graph.v1.python.rtcconf import config
from crypta.graph.v1.python.utils import yt_clients


def link_access_logs():
    access_logs = [
        "afisha-access-log",
        "appmetrica-mobile-startup-http-request-log",
        "billing-access-log",
        "cdn-access-log",
        "collections-access-log",
        "direct-access-log",
        "disk-front-access-log",
        "doc-production-access-log",
        "fotki-access-log",
        "kassa-access-log",
        "kinopoisk-tskv-front-log",
        "mail-access-log",
        "market-new-access-log",
        "mobile-front-access-log",
        "morda-access-log",
        "mrparser-access-log",
        "music-nginx-access-log",
        "partner-access-log",
        "passport-access-log",
        "rasp-access-log",
        "stat-access-log",
        "static-access-log",
        "tech-access-log",
        "tv-access-log",
        "vertis-access-log",
        "video-access-log",
        "voice-stream-access-log",
        "weather-access-log",
        "widgets-access-log",
        "yandex-access-log",
        "yastore-access-log",
    ]

    yt_client = yt_clients.get_yt_client()
    with yt_client.Transaction():
        if not yt_client.exists(config.ACCESS_LOGS_FOLDER):
            yt_client.mkdir(config.ACCESS_LOGS_FOLDER, recursive=True)

        for al in access_logs:
            log_path = os.path.join(config.CRYPTA_GRAPH_LOGFELLER_YT_PATH, al, "1d")
            link_path = os.path.join(config.ACCESS_LOGS_FOLDER, al)

            if not yt_client.exists(link_path):
                yt_client.link(log_path, link_path)
