from __future__ import print_function

import yt.wrapper as yt

from crypta.graph.v1.python.utils import yt_clients
from crypta.graph.v1.python.rtcconf import config


def conditions(chunks, size):
    if not chunks or not size:
        return False
    if size < 150 * (10 ** 6) and chunks > 5:
        return True
    elif size < 150 * (10 ** 6) and chunks < 6:
        return False
    if (10 ** 8) > (size // chunks):
        return True
    elif (size // chunks) > 5 * (10 ** 8):
        return True
    return False


def merge_v1_dicts():
    to_merge = []
    yt_client = yt_clients.get_yt_client()
    all_tables = yt_client.search(
        config.GRAPH_YT_DICTS_FOLDER[:-1], node_type=["table"], attributes=["resource_usage"]
    )

    for yson_path in all_tables:
        resource_usage = yson_path.attributes["resource_usage"]
        chunks = resource_usage["chunk_count"]
        space = resource_usage["disk_space"]
        if conditions(chunks, space):
            to_merge.append((str(yson_path), space, chunks))

    print("TABLES TO MERGE:\n\t%s" % "\n\t".join("%s:\tsize:%s, chunks:%s" % tp for tp in to_merge))

    for tbl, space, chunks in to_merge:
        try:
            print("MERGING TABLE %s" % tbl)
            yt_client.run_merge(tbl, tbl, spec=dict(combine_chunks=True, annotations={"script_name": "postproc"}))
            print("%s MERGED" % tbl)
        except Exception as e:
            print("FAIL MERGING TABLES: %s" % str(e))


if "__main__" == __name__:
    yt.config.set_proxy("hahn.yt.yandex.net")
    merge_v1_dicts()
