from __future__ import print_function
import luigi

from crypta.graph.v1.python.utils import mr_utils as mr
from crypta.graph.v1.python.utils import utils
from crypta.graph.v1.python.data_imports.import_logs import graph_access
from crypta.graph.v1.python.rtcconf import config


class RunAllDayTasks(luigi.WrapperTask):
    date = luigi.Parameter()
    run_date = luigi.Parameter()
    drop = False  # change it!

    def requires(self):
        tasks = []
        for date in utils.get_dates_before(self.date, int(config.STORE_DAYS)):
            # tasks.append(graph_barnavig.ImportBarNavigDayTask(date=date, run_date=self.run_date))
            tasks.append(graph_access.ImportAccessLogsDayTask(date=date, run_date=self.run_date))
            # tasks.append(log_watch.ImportWatchLogDayTask(date=date, run_date=self.run_date))
            # tasks.append(graph_passport.ImportPassportPhoneDayTask(date=date, run_date=self.run_date))
            # tasks.append(graph_import_fp_bb.ImportFPDayTask(date=date, run_date=self.run_date))
            # tasks.append(device_yuids_oauth_redir.ImportOauthAndRedirLogsDayTask(date=date, run_date=self.run_date))
            # tasks.append(device_yuids_tracking.ImportMobileTrackingLogsDayTask(date=date, run_date=self.run_date))

        # force drop to make luigi think that it needs to re-create tables
        if self.drop:
            for task in tasks:
                for outp in utils.flatten(task.output()):
                    print("Dropping %s" % outp.table)
                    mr.drop(outp.table)
            self.drop = False

        return tasks
