#!/usr/bin/pyhton
"""
Crypta graph base luigi task
"""

import logging

import luigi
from luigi.task import flatten, externalize

from crypta.graph.v1.python.rtcconf import config


class BaseTask(luigi.Task):
    def on_success(self):
        return "Success"

    def log_yt_targets_check(self, targets):
        targets = list(targets)

        logging.info("Checking %s targets:" % self.get_task_family())

        for t in targets:
            if t.exists():
                logging.info("%s target exists: %s" % (self.get_task_family(), t.table))
            else:
                logging.info("%s target is missing: %s" % (self.get_task_family(), t.table))

        return targets

    @staticmethod
    def _externalize_tagged_dependency(task, run_tags, no_filter_tags, fail_on_tags):
        task_type = type(task)
        task_tags = task_type.tags if hasattr(task_type, "tags") else []

        if fail_on_tags and any(t in fail_on_tags for t in task_tags):
            raise Exception(
                "Dependency on %s having one of forbidden tags %s" % (task.get_task_family(), fail_on_tags)
            )

        def check_make_external():
            if isinstance(task, luigi.ExternalTask):
                # already external
                return False

            if no_filter_tags and any(t in no_filter_tags for t in task_tags):
                # task with no tag are not affected by no_run_tags
                return True

            return run_tags and not any(t in run_tags for t in task_tags)

        if check_make_external():
            logging.info("Externalize %s" % task.get_task_family())
            # raise Exception("%s %s %s" % (run_tags, no_filter_tags, fail_on_tags))
            return externalize(task)
        else:
            logging.info("Not externalize %s" % task.get_task_family())
            return task

    def _requires(self):
        run_tags = config.LUIGI_RUN_TAGS
        no_filter_tags = config.LUIGI_FILTER_TAGS
        fail_on_tags = config.LUIGI_FAIL_TAGS

        required_tasks = flatten(self.requires())
        if run_tags or no_filter_tags or fail_on_tags:
            return [
                self._externalize_tagged_dependency(t, run_tags, no_filter_tags, fail_on_tags) for t in required_tasks
            ]
        else:
            return required_tasks
