from collections import namedtuple

from crypta.graph.v1.python.rtcconf import config
from crypta.graph.v1.python.rtcconf.config import (
    ID_TYPE_DEVID,
    ID_TYPE_UUID,
    ID_TYPE_PUID,
    ID_TYPE_YUID,
    ID_TYPE_MMETRIC_DEVID,
)


class MergeConfig(namedtuple("MergeConfig", "id1, id2, source_type")):
    def table_name(self):
        return self.id1 + "_" + self.id2 + "_" + self.source_type


merge_configs_daily = [
    MergeConfig(ID_TYPE_UUID, ID_TYPE_PUID, config.ID_SOURCE_TYPE_PASSPORT_OAUTH),
    MergeConfig(ID_TYPE_MMETRIC_DEVID, ID_TYPE_PUID, config.ID_SOURCE_TYPE_PASSPORT_OAUTH),
    MergeConfig(ID_TYPE_UUID, ID_TYPE_YUID, config.ID_SOURCE_TYPE_TRACK),
    MergeConfig(ID_TYPE_UUID, ID_TYPE_YUID, config.ID_SOURCE_TYPE_REDIR),
    MergeConfig(ID_TYPE_UUID, ID_TYPE_YUID, config.ID_SOURCE_TYPE_ACCESS_LOG),
    MergeConfig(ID_TYPE_UUID, ID_TYPE_YUID, config.ID_SOURCE_TYPE_WATCH_LOG),
    MergeConfig(ID_TYPE_UUID, ID_TYPE_YUID, config.ID_SOURCE_TYPE_YABROWSER_ANDROID),
    MergeConfig(ID_TYPE_UUID, ID_TYPE_YUID, config.ID_SOURCE_TYPE_SDK),
    MergeConfig(ID_TYPE_UUID, ID_TYPE_YUID, config.ID_SOURCE_TYPE_METRICA_SOCKETS_ANDROID),
    MergeConfig(ID_TYPE_UUID, ID_TYPE_YUID, config.ID_SOURCE_TYPE_METRICA_SOCKETS_IOS),
    MergeConfig(ID_TYPE_DEVID, ID_TYPE_YUID, config.ID_SOURCE_TYPE_METRICA_SOCKETS_ANDROID),
    MergeConfig(ID_TYPE_DEVID, ID_TYPE_YUID, config.ID_SOURCE_TYPE_METRICA_SOCKETS_IOS),
    MergeConfig(ID_TYPE_DEVID, ID_TYPE_YUID, config.ID_SOURCE_TYPE_POSTCLICK),
    MergeConfig(ID_TYPE_MMETRIC_DEVID, ID_TYPE_YUID, config.ID_SOURCE_TYPE_WATCH_YP_IOS),
    MergeConfig(ID_TYPE_MMETRIC_DEVID, ID_TYPE_YUID, config.ID_SOURCE_TYPE_WATCH_YP_ANDROID),
    MergeConfig(ID_TYPE_MMETRIC_DEVID, ID_TYPE_YUID, config.ID_SOURCE_TYPE_ACCESS_YP_IOS),
    MergeConfig(ID_TYPE_MMETRIC_DEVID, ID_TYPE_YUID, config.ID_SOURCE_TYPE_ACCESS_YP_ANDROID),
]

merge_configs_monthly = [
    MergeConfig(ID_TYPE_DEVID, ID_TYPE_YUID, config.ID_SOURCE_TYPE_ACCOUNT_MANAGER),
    MergeConfig(ID_TYPE_DEVID, ID_TYPE_YUID, config.ID_SOURCE_TYPE_VMETRO),
]

merge_configs = merge_configs_daily + merge_configs_monthly
