import os

from crypta.graph.v1.python.rtcconf import config

from sandbox.common import rest
from sandbox.common.proxy import OAuth


def upload_bb(table, name, delete_flag=False):
    if config.CRYPTA_ENV == "develop":
        return

    client = rest.Client(auth=OAuth(config.SANDBOX_OAUTH))
    task_id = client.task({"type": "CRYPTA_GRAPH_BOCHKA"})["id"]
    client.task[task_id] = {
        "owner": "CRYPTA",
        "tags": ["yt2lb", "v1", "-".join(name.split())],
        "custom_fields": [
            {"name": "environment", "value": ("testing", "stable")[config.CRYPTA_ENV == "production"]},
            {"name": "pool", "value": os.getenv("YT_POOL")},
            {"name": "source_path", "value": table},
            {"name": "task", "value": "crypta.graph.bochka.lib.tasks.Yt2BBPushTask"},
            {"name": "options", "value": {"--collector-table-prefix": "_".join(name.split())}},
        ],
        "notifications": [
            {
                "transport": "email",
                "recipients": ["mskorokhod", "crypta-cryptaid@yandex-team.ru"],
                "statuses": ["EXCEPTION", "EXPIRED", "FAILURE", "TIMEOUT"],
            }
        ],
    }
    response = client.batch.tasks.start.update([task_id])

    assert response[0]["status"] == "SUCCESS", "Sandbox should start with success status!"
