CRYPTA_ID_MAGIC_NUMBERS = {"offline_matching": "5", "online_is": "3", "experiments": "0"}


def yuid_to_crypta_id(yuid):
    yuid_random_seq = yuid[:-10]
    yuid_ts = yuid[-10:]

    magic_number = CRYPTA_ID_MAGIC_NUMBERS["offline_matching"]

    # replace first ts number (always equals 1) with magic number
    return yuid_random_seq + magic_number + yuid_ts[1:]


def change_crypta_id_for_experiment(yuid, experiment_number):
    yuid_random_seq = yuid[:-10]
    yuid_ts = yuid[-10:]

    magic_number = CRYPTA_ID_MAGIC_NUMBERS["experiments"]

    return yuid_random_seq + magic_number + str(experiment_number) + yuid_ts[2:]
