import luigi

from crypta.graph.soup.config.python import ID_TYPE
from crypta.graph.v1.python.data_imports.import_logs.graph_import_fp import ImportFPDayTask
from crypta.graph.v1.python.lib.luigi import yt_luigi
from crypta.graph.v1.python.rtcconf import config
from crypta.graph.v1.python.utils import mr_utils as mr, utils
from crypta.graph.v1.python.utils.yql_utils import run_yql


class YuidInfoMonth(yt_luigi.BaseYtTask):
    date = luigi.Parameter()

    def output_folders(self):
        return {"ids": config.CRYPTA_IDS_STORAGE}

    def requires(self):
        return [
            ImportFPDayTask(date=d, run_date=self.date)
            for d in utils.get_dates_before(self.date, int(config.STORE_DAYS))
        ] + [yt_luigi.ExternalInput(config.PROFILES_EXPORT)]

    def run(self):

        with self.yt.Transaction() as trx:
            run_yql(
                "YuidInfoMonthAggregator",
                dict(
                    date_start=utils.get_date_before(self.date, int(config.STORE_DAYS)),
                    date_end=self.date,
                ),
                context=dict(transaction_id=trx.transaction_id),
            )

        yuid_with_all_info = self.out_f("ids") + ID_TYPE.YANDEXUID.Name + "/yuid_with_all_info"
        yuid_with_all_light_by_yuid = self.out_f("ids") + ID_TYPE.YANDEXUID.Name + "/yuid_with_all_light_by_yandexuid"

        mr.set_generate_date(yuid_with_all_info, self.date)
        mr.set_generate_date(yuid_with_all_light_by_yuid, self.date)

    def output(self):
        return [
            yt_luigi.YtDateTarget(t, self.date)
            for t in [
                self.out_f("ids") + ID_TYPE.YANDEXUID.Name + "/yuid_with_all_info",
                self.out_f("ids") + ID_TYPE.YANDEXUID.Name + "/yuid_with_all_light_by_yandexuid",
            ]
        ]
