import logging

import yt.wrapper as yt

from crypta.graph.v1.python.infra import merge_graph_tables
from crypta.graph.v1.python.infra.graph_postproc import run_postproc
from crypta.graph.v1.python.rtcconf import config


def main(unsafe_mode=False):
    yt.config.set_proxy(config.MR_SERVER)

    logging.basicConfig(level="INFO")
    run_postproc(safe_mode=not unsafe_mode)
    merge_graph_tables.merge_v1_dicts()


if "__main__" == __name__:
    main()
