from __future__ import print_function
import os
import logging

from crypta.lib.python import script_name
from crypta.lib.python.yql_runner.base_parser import BaseParser
import crypta.lib.python.yql_runner.runner  # noqa

# These imports make BaseParser subclasses visible
import crypta.graph.data_import.app_metrica_day.lib  # noqa
import crypta.graph.data_import.app_metrica_month.lib  # noqa
import crypta.graph.data_import.autoru_log.lib  # noqa
import crypta.graph.data_import.chevent_log.lib  # noqa
import crypta.graph.data_import.fp_parser.lib  # noqa
import crypta.graph.data_import.fuzzy2.lib  # noqa
import crypta.graph.data_import.metrika_user_params.lib  # noqa
import crypta.graph.data_import.radius_filter.lib  # noqa
import crypta.graph.data_import.passport.lib  # noqa
import crypta.graph.data_import.soup.lib  # noqa
import crypta.graph.data_import.visit_log.lib  # noqa
import crypta.graph.data_import.watch_log.lib  # noqa
import crypta.graph.data_import.webvisor.lib  # noqa
import crypta.graph.data_import.yuid_info_month.lib  # noqa
import crypta.graph.yuid_apps  # noqa


from crypta.graph.v1.python.rtcconf import config


def run_yql(class_name=None, params=None, query=None, is_embedded=False, context=None):
    assert class_name is not None or query is not None
    if query is not None:
        class_name = "YqlRunner"

    subclasses = {x.__name__: x for x in BaseParser.__subclasses__()}
    if class_name not in subclasses:
        raise Exception('Task class "{}" is unknown (expected one of: {})'.format(class_name, ", ".join(subclasses)))

    if config.YQL_FORCE_EMBEDDED or (config.CRYPTA_ENV == "development"):
        is_embedded = True

    task_args = dict(
        yt_proxy=config.MR_SERVER,
        pool=os.getenv("YT_POOL"),
        mrjob_binary=config.YQL_MRJOB,
        udf_resolver_binary=config.YQL_UDF_RESOLVER,
        udfs_dir=config.YQL_UDF_DIR,
        is_embedded=is_embedded,
        crypta_env=config.CRYPTA_ENV,
        loglevel="INFO",
    )

    task_args.update(params or {})
    if class_name == "YqlRunner":
        # special case: run arbitrary yql from query
        task_args["query"] = query
        task_args["script_name"] = script_name.detect_script_name()

    logging.info("Running {} with params {}".format(class_name, task_args))

    task = subclasses[class_name](**task_args)
    assert task.get_token(), "Env variable YT_TOKEN required!"

    extra_context = {"SKIP_INPUT_DATA": config.SKIP_INPUT_DATA}
    if context is not None:
        extra_context.update(context)

    if os.getenv("VERBOSE") or (class_name == "YqlRunner"):
        print(task.render_query(**extra_context))

    return task.run(**extra_context)
