#!/usr/bin/env python
import os

import yt.wrapper as yt

from crypta.graph.v1.python.rtcconf import config

yt_instances = {}


def get_yt_client(token=None):
    if token is None:
        token = os.getenv("YT_TOKEN")

    global yt_instances

    client_key = os.getpid()
    if client_key not in yt_instances:
        client = yt.YtClient(proxy=config.MR_SERVER, token=token, config=yt.config.config)
        client.config["tabular_data_format"] = yt.YsonFormat(control_attributes_mode="row_fields")
        yt_instances[client_key] = client

    return yt_instances[client_key]


class YtClientMixin(object):
    @property
    def yt(self):
        return get_yt_client()
