pragma yt.ExternalTx = '{{ tx }}';
pragma SimpleColumns;

$dt = '{{ date }}';

$all = (
    select
        Identifiers::Normalize(id_type, id) AS id,
        id_type,
        app_id,
        app_version,
        os,
        Yson::ConvertToInt64Dict(api_keys) AS api_keys,
        ListMin(dates) ?? $dt AS date_begin,
        ListMax(dates) ?? $dt AS date_end
    FROM `{{ day_table }}`
    WITH COLUMNS Struct<`dates`: List<String>?>
    WHERE Identifiers::IsValid(id_type, id)
    UNION ALL
    SELECT
        Yson::ConvertToInt64Dict(t.api_keys) AS api_keys,
        t.* WITHOUT api_keys
    FROM `{{ idstorage_table }}` AS t
);

$merged_0 = (
    select
        id,
        id_type,
        min(date_begin) AS date_begin,
        max(date_end) AS date_end,
        max_by(app_id, date_end) AS app_id,
        max_by(app_version, date_end) AS app_version,
        max_by(os, date_end) AS os,
        AGGREGATE_LIST(api_keys) AS api_keys
    from $all
    group by id_type, id
);

$merged_1 = (
    SELECT
        id,
        id_type,
        date_begin,
        date_end,
        app_id,
        app_version,
        os,
        CASE WHEN ListLength(api_keys) == 0 THEN DictCreate(String, Int64)
             WHEN ListLength(api_keys) == 1 THEN api_keys[0]
             ELSE SetUnion(
                api_keys[0],
                api_keys[1],
                ($k, $a, $b) -> {
                    RETURN NVL($a, 0) + NVL($b, 0);
                })
        END AS api_keys
    FROM $merged_0
);

$merged = (
    SELECT
        Yson::Serialize(
            Yson::FromInt64Dict(
                NVL(
                    t.api_keys,
                    DictCreate(String, Int64)
                )
            )
        ) AS api_keys,
        t.* without api_keys
    FROM $merged_1 AS t
);

DEFINE ACTION $final_merge($id_type, $tbl) AS
    INSERT INTO $tbl WITH TRUNCATE
    SELECT
    {% if soup_dates_enabled|default(False) %}
        ListMin(AsList(merge.date_begin, soup.date_begin)) AS date_begin,
        ListMax(AsList(merge.date_end, soup.date_end)) AS date_end,
        merge.* WITHOUT merge.date_begin, merge.date_end
    {% else %}
        merge.*
    {% endif %}
    FROM $merged AS merge
    {% if soup_dates_enabled|default(False) %}
    LEFT JOIN ANY $soup_dates('{{ soup_root }}', $id_type) AS soup
    USING (id_type, id)
    {% endif %}
    WHERE merge.id_type == $id_type
    ORDER BY id_type, id;
END DEFINE;

DO $final_merge('{{ id_type }}', '{{ tmp }}');
