pragma yt.ExternalTx = '{{ tx }}';
pragma SimpleColumns;

$dt = '{{ date }}';

$later_value = ($val1, $date1, $val2, $date2) -> {
    return IF(
        $date2 > $date1,
        $val2 ?? $val1, -- value is better then missing value anyway
        $val1 ?? $val2
    );
};

$daily = (
    select
        Identifiers::Normalize(id_type, id) as id,
        id_type,
        browser_name,
        browser_version,
        os_name,
        os_family,
        os_version,
        is_emulator,
        is_browser,
        is_mobile,
        is_tablet,
        is_touch,
        is_robot,
        is_tv,
        nvl(WeakField(date_begin, 'String'), $dt) as date_begin,
        nvl(WeakField(date_end, 'String'), $dt) as date_end,
        WeakField(ts, 'Uint64', 0) as ts
    from EACH(AsList('{{ day_tables | join("', '") | safe }}'))
    where Identifiers::IsValid(id_type, id)
);

$group_daily = (
    select id, id_type,
        max_by(browser_name, ts) as browser_name,
        max_by(browser_version, ts) as browser_version,
        max_by(os_name, ts) as os_name,
        max_by(os_family, ts) as os_family,
        max_by(os_version, ts) as os_version,
        max_by(is_emulator, ts) as is_emulator,
        max_by(is_browser, ts) as is_browser,
        max_by(is_mobile, ts) as is_mobile,
        max_by(is_tablet, ts) as is_tablet,
        max_by(is_touch, ts) as is_touch,
        max_by(is_robot, ts) as is_robot,
        max_by(is_tv, ts) as is_tv,
        min(date_begin) as date_begin,
        max(date_end) as date_end
    from $daily
    group by id, id_type
);

$merged = (
    select
        $later_value(
            day.id, day.date_end,
            eternal.id, eternal.date_end
        ) as id,
        $later_value(
            day.id_type, day.date_end,
            eternal.id_type, eternal.date_end
        ) as id_type,
        $later_value(
            day.browser_name, day.date_end,
            eternal.browser_name, eternal.date_end
        ) as browser_name,
        $later_value(
            day.browser_version, day.date_end,
            eternal.browser_version, eternal.date_end
        ) as browser_version,
        $later_value(
            day.os_name, day.date_end,
            eternal.os_name, eternal.date_end
        ) as os_name,
        $later_value(
            day.os_family, day.date_end,
            eternal.os_family, eternal.date_end
        ) as os_family,
        $later_value(
            day.os_version, day.date_end,
            eternal.os_version, eternal.date_end
        ) as os_version,
        $later_value(
            day.is_emulator, day.date_end,
            eternal.is_emulator, eternal.date_end
        ) as is_emulator,
        $later_value(
            day.is_browser, day.date_end,
            eternal.is_browser, eternal.date_end
        ) as is_browser,
        $later_value(
            day.is_mobile, day.date_end,
            eternal.is_mobile, eternal.date_end
        ) as is_mobile,
        $later_value(
            day.is_tablet, day.date_end,
            eternal.is_tablet, eternal.date_end
        ) as is_tablet,
        $later_value(
            day.is_touch, day.date_end,
            eternal.is_touch, eternal.date_end
        ) as is_touch,
        $later_value(
            day.is_robot, day.date_end,
            eternal.is_robot, eternal.date_end
        ) as is_robot,
        $later_value(
            day.is_tv, day.date_end,
            eternal.is_tv, eternal.date_end
        ) as is_tv,
        -- for some reason eternal date_begin is String?,
        -- we use Unwrap to eliminate optional resulting value
        Unwrap(ListMin(AsList(eternal.date_begin, day.date_begin))) as date_begin,
        -- for some reason eternal date_begin is String?,
        -- we use Unwrap to eliminate optional resulting value
        Unwrap(ListMax(AsList(eternal.date_end, day.date_end))) as date_end
    from any $group_daily as day
    full join any `{{ idstorage_table }}` as eternal
    using (id, id_type)

);

DEFINE ACTION $final_merge($id_type, $tbl) AS
    {%
        if throw_before_date and not (
            (crypta_env == "testing")
                or (crypta_env == "development")
            )
    %}
    {{ "WARNING! SHOULD NEVER BE ON PROD!!!" / 0 }}
    {% endif %}

    INSERT INTO $tbl WITH TRUNCATE
    SELECT * FROM (
        SELECT
        {% if soup_dates_enabled|default(False) %}
            ListMin(AsList(merge.date_begin, soup.date_begin)) AS date_begin,
            ListMax(AsList(merge.date_end, soup.date_end)) AS date_end,
            merge.* WITHOUT merge.date_begin, merge.date_end
        {% else %}
            merge.*
        {% endif %}
        FROM $merged AS merge
        {% if soup_dates_enabled|default(False) %}
        LEFT JOIN ANY $soup_dates('{{ soup_root }}', $id_type) AS soup
        USING (id_type, id)
        {% endif %}
        WHERE merge.id_type == $id_type
    ){% if throw_before_date %}WHERE date_end > '{{ throw_before_date }}'{% endif %}
    ORDER BY id_type, id;
END DEFINE;

DO $final_merge('{{ id_type }}', '{{ out }}');
