pragma yt.ExternalTx = '{{ tx }}';

$dt = '{{ date }}';

$day_data = (
    SELECT
        Identifiers::Normalize(id_type, id) AS id,
        id_type,
        manufacturer,
        model,
        os,
        os_version,
        screen_width,
        screen_height,
        ListMin(dates) ?? $dt AS date_begin,
        ListMax(dates) ?? $dt AS date_end
    FROM `{{ day_table }}`
    WITH COLUMNS Struct<`dates`: List<String>?>
    WHERE Identifiers::IsValid(id_type, id)
);

$ids_storage = (
    SELECT * FROM EACH(
        AsList(
            '{{ idstorage_tables.values() | join("', '") | safe }}'
        )
    )
);

INSERT INTO @merged
SELECT
    id,
    id_type,
    min(date_begin) AS date_begin,
    max(date_end) AS date_end,
    max_by(manufacturer, date_end) AS manufacturer,
    max_by(model, date_end) AS model,
    max_by(os, date_end) AS os,
    max_by(os_version, date_end) AS os_version,
    max_by(screen_width, date_end) AS screen_width,
    max_by(screen_height, date_end) AS screen_height,
FROM (
    SELECT * FROM $day_data
    UNION ALL
    SELECT * FROM $ids_storage
) GROUP BY id_type, id
ORDER BY id_type, id;

DEFINE ACTION $final_merge($id_type, $tbl) AS
    INSERT INTO $tbl WITH TRUNCATE
    SELECT
    {% if soup_dates_enabled|default(False) %}
        ListMin(AsList(merge.date_begin, soup.date_begin)) AS date_begin,
        ListMax(AsList(merge.date_end, soup.date_end)) AS date_end,
        merge.* WITHOUT merge.date_begin, merge.date_end
    {% else %}
        merge.*
    {% endif %}
    FROM @merged AS merge
    {% if soup_dates_enabled|default(False) %}
    LEFT JOIN ANY $soup_dates('{{ soup_root }}', $id_type) AS soup
    USING (id_type, id)
    {% endif %}
    WHERE merge.id_type == $id_type
    ORDER BY id_type, id;
END DEFINE;

COMMIT;

{% for id_type, table_path in idstorage_tables.iteritems() %}
    DO $final_merge('{{ id_type }}', '{{ table_path }}');
{% endfor %}
