PRAGMA yt.ExternalTx = '{{ tx }}';

$all = (
    SELECT duid, yandexuid, counter_id, last_ts,
    FROM EACH(AsList('{{ day_tables | join("', '") | safe }}'))

    UNION ALL

    SELECT duid, yandexuid, counter_id, last_ts,
    FROM `{{ idstorage_table }}`
);

$groupped_duid_index = (
    SELECT duid, yandexuid, counter_id, MAX(last_ts) AS last_ts,
    FROM $all
    GROUP BY duid, yandexuid, counter_id
);

INSERT INTO `{{ out }}` WITH TRUNCATE
SELECT duid, yandexuid, counter_id,
    last_ts,
FROM $groupped_duid_index
WHERE last_ts > {{ min_active_date.strftime("%s") }}
ORDER BY duid, yandexuid, counter_id;
