$soup_dir = '{{ soup_dir }}/';
$out_dir = '{{out_dir}}/';

$prefiltered = (
    SELECT
        id1, id1Type, id2, id2Type
    FROM EACH(AsList(
        {% for edge_type in edge_types_list %}
            $soup_dir || '{{edge_type}}' {{ "," if not loop.last }}
        {% endfor %}
    ))
);

$all_ids = (
    SELECT
        id,
        id_type
    FROM (
        select
            id1 as id,
            id1Type as id_type
        from $prefiltered
        union all
        select
            id2 as id,
            id2Type as id_type
        from $prefiltered
    ) group by id, id_type
);


{% for id_type in id_types_list %}
$out_table_{{loop.index}} = $out_dir || '{{id_type}}';
INSERT INTO $out_table_{{loop.index}} WITH TRUNCATE
SELECT * FROM $all_ids
where id_type = '{{id_type}}'
ORDER BY id_type, id;
{% endfor %}
