from crypta.lib.python.identifiers.identifiers import GenericID
from crypta.graph.soup.config.python import EDGE_TYPE as edges  # N811 # noqa


def is_valid_dates(record):
    try:
        edge_type = edges.get_edge_type_by_name(
            record["id1Type"], record["id2Type"], record["sourceType"], record["logSource"]
        )
        if edge_type.Props.ActivityType == edge_type.Props.DAILY:
            return bool(record.get("dates") or record.get("date"))
    except KeyError:
        pass
    return True


def normalize(id_type, id_value):
    identifier = GenericID(id_type, id_value)
    if identifier.is_valid():
        return identifier.normalize


def normalize_rec(rec):
    id1 = normalize(rec["id1Type"], rec["id1"])
    id2 = normalize(rec["id2Type"], rec["id2"])
    if id1 and id2 and is_valid_dates(rec):
        if rec["id1Type"] == rec["id2Type"]:
            id1, id2 = min(id1, id2), max(id1, id2)
        rec["id1"] = id1
        rec["id2"] = id2
        return rec
    return None


def get_md5(id_type, id_value):
    identifier = GenericID(id_type, id_value)
    if identifier.is_valid():
        return identifier.md5
