PY2_LIBRARY(crypta-graph-v1)

OWNER(
    g:crypta
    g:crypta-idfy
)

PY_SRCS(
    __init__.py
    graph_all.py
    graph_v1.py
    graph_v2.py
    import_soup.py
    matching/graph_resulted_pairs_tables.py
    matching/__init__.py
    matching/pairs/graph_pairs.py
    matching/pairs/stats/__init__.py
    matching/pairs/stats/graph_pairs_sources_stat.py
    matching/pairs/stats/graph_stat_passport.py
    matching/pairs/__init__.py
    matching/pairs/graph_pair_utils.py
    matching/pairs/graph_pairs_black_list.py
    matching/yuid_matching/graph_merge_month.py
    matching/yuid_matching/stats/__init__.py
    matching/yuid_matching/stats/graph_stat_id.py
    matching/yuid_matching/__init__.py
    matching/yuid_matching/graph_unsplice.py
    matching/yuid_matching/graph_dict.py
    matching/yuid_matching/graph_yuid_info.py
    matching/yuid_matching/enrich/__init__.py
    matching/yuid_matching/enrich/org_emails_classify.py
    matching/yuid_matching/enrich/puid_yuid_passport.py
    matching/export/__init__.py
    matching/export/graph_upload_bb.py
    matching/human_matching/graph_clustering.py
    matching/human_matching/stats/__init__.py
    matching/human_matching/stats/graph_quality_metrics.py
    matching/human_matching/stats/radius/radius_metrics_mr.py
    matching/human_matching/stats/radius/__init__.py
    matching/human_matching/stats/radius/radius_metrics.py
    matching/human_matching/stats/radius/radius_metrics_calc.py
    matching/human_matching/stats/graph_stat_vertices.py
    matching/human_matching/__init__.py
    matching/human_matching/crypta_id_generator.py
    matching/human_matching/graph_vertices_reassign.py
    matching/human_matching/graph_vertices.py
    matching/human_matching/graph_vertices_pretty.py
    matching/human_matching/graph_vertices_base.py
    matching/device_matching/indevice_utils.py
    matching/device_matching/perfect/__init__.py
    matching/device_matching/perfect/merge_month_perfect.py
    matching/device_matching/perfect/config.py
    matching/device_matching/perfect/enrich/device_yuid_perfect_enrich.py
    matching/device_matching/perfect/enrich/__init__.py
    matching/device_matching/perfect/enrich/devid_email_phone_am.py
    matching/device_matching/perfect/enrich/devid_mac_vmetro.py
    matching/device_matching/perfect/device_yuid_perfect_dict.py
    matching/device_matching/perfect/device_yuid_perfect_by_source.py
    matching/device_matching/__init__.py
    matching/device_matching/distr/yuid_distr_ui_desktop.py
    matching/device_matching/distr/__init__.py
    matching/device_matching/distr/device_yuid_distr_dicts.py
    matching/device_matching/app_metrica/account_manager_decoder/rsa_key.py
    matching/device_matching/app_metrica/account_manager_decoder/decoder.py
    matching/device_matching/app_metrica/account_manager_decoder/__init__.py
    matching/device_matching/app_metrica/app_metrica_month.py
    matching/device_matching/app_metrica/account_manager.py
    matching/device_matching/app_metrica/app_metrica_to_old_formats.py
    matching/device_matching/app_metrica/__init__.py
    matching/device_matching/app_metrica/app_metrica_dict_schemas.py
    matching/common_stats/__init__.py
    matching/common_stats/graph_stat.py
    matching/common_stats/graph_stat_report.py
    #tools/__init__.py
    #tools/startrek.py
    #tools/disk_space.py
    rtcconf/__init__.py
    rtcconf/config.py
    lib/yt_trace.py
    lib/graphite_sender.py
    lib/__init__.py
    lib/sandbox/__init__.py
    lib/sandbox/api.py
    lib/sandbox/env.py
    lib/crypta_api/__init__.py
    lib/crypta_api/crypta_task_status_api.py
    lib/luigi/luigi_runner.py
    lib/luigi/base_luigi_task.py
    lib/luigi/__init__.py
    lib/luigi/yt_luigi.py
    lib/luigi/smart_runner.py
    # v2
    v2/__init__.py
    v2/ids.py
    v2/yuid_apps.py
    v2/v2_task_status.py
    v2/table_register.py
    v2/ids_storage/__init__.py
    v2/ids_storage/column_aggregators.py
    v2/ids_storage/eternal.py
    v2/shared/__init__.py
    v2/shared/heuristic_desktop_yuids.py
    v2/shared/yandex_drive.py
    v2/soup/__init__.py
    v2/soup/backup.py
    v2/soup/graph_soup_cook.py
    v2/soup/graph_soup_cook_yql.py
    v2/soup/graph_soup_update.py
    v2/soup/indevice_fuzzy2.py
    v2/soup/soup_dirs.py
    v2/soup/soup_storage_yql_schema.py
    v2/soup/soup_tables.py
    v2/soup/soup_utils.py
    v2/soup/soup_validation.py
    data_imports/day_aggregate.py
    data_imports/__init__.py
    data_imports/import_active_dumps/market/__init__.py
    data_imports/import_active_dumps/market/market_orders.py
    data_imports/import_active_dumps/metrika_user_params/__init__.py
    data_imports/import_active_dumps/metrika_user_params/user_params.py
    data_imports/import_dumps/__init__.py
    data_imports/import_dumps/graph_import_bb.py
    data_imports/import_dumps/graph_passport_dump.py
    data_imports/import_dumps/graph_tickets.py
    data_imports/import_dumps/graph_yamoney.py
    data_imports/import_dumps/partners/__init__.py
    data_imports/import_dumps/partners/import_other_dumps.py
    data_imports/import_dumps/partners/trusted_partners.py
    data_imports/import_dumps/sherlock/__init__.py
    data_imports/import_dumps/sherlock/import_vkid_mail.py
    data_imports/import_dumps/social/__init__.py
    data_imports/import_dumps/social/graph_social_auth.py
    data_imports/import_dumps/social/social_auth_providers.py
    data_imports/import_logs/__init__.py
    data_imports/import_logs/app_metrica_day.py
    data_imports/import_logs/autoru/__init__.py
    data_imports/import_logs/autoru/graph_autoru.py
    data_imports/import_logs/bs/__init__.py
    data_imports/import_logs/bs/xuniq.py
    data_imports/import_logs/chevent_log.py
    data_imports/import_logs/device_yuids_oauth.py
    data_imports/import_logs/device_yuids_redir.py
    data_imports/import_logs/device_yuids_sdk.py
    data_imports/import_logs/device_yuids_tracking.py
    data_imports/import_logs/graph_access.py
    data_imports/import_logs/graph_barnavig.py
    data_imports/import_logs/graph_dmp_ditmsk.py
    data_imports/import_logs/graph_eal.py
    data_imports/import_logs/graph_import_fp.py
    data_imports/import_logs/graph_passport.py
    data_imports/import_logs/graph_passport_sensitive.py
    data_imports/import_logs/graph_postclicks.py
    data_imports/import_logs/graph_rassilyator.py
    data_imports/import_logs/graph_sbapi_lookup.py
    data_imports/import_logs/graph_sovetnik.py
    data_imports/import_logs/graph_watch_log.py
    data_imports/import_logs/import_kinopoisk_access.py
    data_imports/import_logs/rtb_log.py
    data_imports/import_logs/postback_log.py
    data_imports/import_logs/visit_log/__init__.py
    data_imports/import_logs/visit_log/graph_visit_log.py
    data_imports/import_logs/webvisor/__init__.py
    data_imports/import_logs/webvisor/graph_webvisor.py
    data_imports/import_other/__init__.py
    utils/__init__.py
    utils/geo_utils.py
    utils/lock.py
    utils/logging_setup.py
    utils/mr_utils.py
    utils/uat_utils.py
    utils/utils.py
    utils/yql_utils.py
    utils/yt_clients.py
    infra/__init__.py
    infra/graph_history_snapshot.py
    infra/graph_postproc.py
    infra/link_access_logs.py
    infra/merge_graph_tables.py
    infra/radius/__init__.py
    infra/radius/export_radius_log.py
    infra/radius/radius_splunk_client.py
    infra/migration_script.py
    run_postproc.py
    run_radius.py
)

RESOURCE(
    v2/soup/query/unique_ids.sql unique_ids.sql.j2
    v2/soup/query/soup_cook.sql soup_cook.sql.j2
    v2/ids_storage/query/apps.sql /ids_storage/apps.sql.j2
    v2/ids_storage/query/cookie.sql /ids_storage/cookie.sql.j2
    v2/ids_storage/query/devices.sql /ids_storage/devices.sql.j2
    v2/ids_storage/query/duids.sql /ids_storage/duids.sql.j2
)

PEERDIR(
    # internal crypta
    crypta/graph/data_import/app_metrica_day/lib
    crypta/graph/data_import/app_metrica_month/lib
    crypta/graph/data_import/autoru_log/lib
    crypta/graph/data_import/chevent_log/lib
    crypta/graph/data_import/export_access_log/lib
    crypta/graph/data_import/fp_parser/lib
    crypta/graph/data_import/fuzzy2/lib
    crypta/graph/data_import/metrika_user_params/lib
    crypta/graph/data_import/passport/lib
    crypta/graph/data_import/radius_filter/lib
    crypta/graph/data_import/soup/lib
    crypta/graph/data_import/visit_log/lib
    crypta/graph/data_import/watch_log/lib
    crypta/graph/data_import/webvisor/lib
    crypta/graph/data_import/yuid_info_month/lib
    crypta/graph/soup/config/python
    crypta/graph/soupy_indevice/lib
    crypta/graph/yuid_apps

    # external crypta
    crypta/contrib/nx_community
    crypta/lib/python/script_name
    crypta/lib/python/identifiers
    crypta/lib/python/tvm/helpers
    crypta/lib/python/yql_runner

    # external
    metrika/uatraits/python
    contrib/python/cryptography
    contrib/python/dateutil
    contrib/python/ipython
    contrib/python/luigi
    contrib/python/namedlist
    contrib/python/requests
    contrib/python/splunk-sdk
    contrib/python/sqlalchemy/sqlalchemy-1.2
    contrib/python/transfer_manager_client
    contrib/python/urllib3
    geobase/python/static
    library/python/statface_client
    library/python/tvmauth
    library/python/reactor/client
    sandbox/common
    yt/python/client
)

END()
