{% set has_previous = previous_state is not none %}

$diff_state = "{{ diff_state }}";
$current_state_tbl = "{{ current_state }}";
$previous_state_tbl = "{{ previous_state }}";
$vertices_by_type_tbl = "{{ vertices_by_type }}";
$vertices_by_id_tbl = "{{ vertices_by_id }}";
$profile_dump = "{{ profile_dump }}";
$cid_history_tbl = "{{ cid_history }}";
$cid_history_export = "{{ cid_history_export }}";

$to_timestamp = ($date) -> {
    RETURN Unwrap(
        DateTime::ToSeconds(
            DateTime::MakeDatetime(
                DateTime::Parse("%Y-%m-%d")($date)
            )
        )
    );
};

$generate_date_ts = EvaluateExpr($to_timestamp("{{ generate_date }}"));

DEFINE ACTION $metrica_diff() AS
    $all_identifiers = (
        SELECT
            id_type,
            id,
            cryptaId AS crypta_id
        FROM $vertices_by_type_tbl
        WHERE id_type IN COMPACT {
            {% for id_type in enabled_id_types %}'{{ id_type }}',{% endfor %}
        }
    );

    $current_state = $all_identifiers;
    $previous_state = $previous_state_tbl;

    $added_or_changed = (
        SELECT
            id_type,
            id,
            crypta_id,
        FROM $current_state AS curr
    {% if has_previous %}
        LEFT ONLY JOIN $previous_state AS prev
        USING (id_type, id, crypta_id)
    {% endif %}
    );

    $deleted = (
        SELECT
            id_type,
            id,
            "0" AS crypta_id,
        FROM $previous_state AS prev
        LEFT ONLY JOIN $current_state AS curr
        USING (id_type, id)
    );

    INSERT INTO $diff_state WITH TRUNCATE
    SELECT id_type, id, crypta_id
    FROM (
        SELECT * FROM $added_or_changed
    {% if has_previous %}
        UNION ALL 
        SELECT * FROM $deleted
    {% endif %}
    ) ORDER BY id_type, id;

    INSERT INTO $current_state_tbl WITH TRUNCATE
    SELECT id_type, id, crypta_id,
    FROM $current_state
    ORDER BY id_type, id;
END DEFINE;

DEFINE ACTION $crypta_id_change_history() AS

    $was_not_changed = (
        SELECT
            l.id AS id,
            l.id_type AS id_type,
            l.cryptaId AS cryptaId,
            l.crypta_ids AS crypta_ids,
        FROM $cid_history_tbl AS l
        LEFT SEMI JOIN $vertices_by_id_tbl AS r
        USING (id, id_type, cryptaId)
    );

    $was_removed = (
        SELECT
            l.id AS id,
            l.id_type AS id_type,
            "0" AS cryptaId,
            IF(
                l.cryptaId != "0",
                ListExtend(l.crypta_ids, [($generate_date_ts, 0)]),
                l.crypta_ids
            ) AS crypta_ids,
        FROM $cid_history_tbl AS l
        LEFT ONLY JOIN $vertices_by_id_tbl AS r
        USING (id, id_type)
    );

    $was_added = (
        SELECT
            l.id AS id,
            l.id_type AS id_type,
            l.cryptaId AS cryptaId,
            [($generate_date_ts, CAST(l.cryptaId AS UInt64) ?? 0)] AS crypta_ids,
        FROM $vertices_by_id_tbl AS l
        LEFT ONLY JOIN $cid_history_tbl AS r
        USING (id, id_type)
    );

    $was_changed = (
        SELECT
            l.id AS id,
            l.id_type AS id_type,
            r.cryptaId AS cryptaId,
            ListExtend(l.crypta_ids, [($generate_date_ts, CAST(r.cryptaId AS UInt64) ?? 0)]) AS crypta_ids,
        FROM $cid_history_tbl AS l
        INNER JOIN ANY $vertices_by_id_tbl AS r
        USING (id, id_type)
        WHERE l.cryptaId != r.cryptaId
    );

    INSERT INTO $cid_history_tbl WITH TRUNCATE
    SELECT id, id_type, cryptaId, crypta_ids
    FROM (
    {% if has_previous %}
        SELECT * FROM $was_not_changed
        UNION ALL SELECT * FROM $was_removed
        UNION ALL SELECT * FROM $was_added
        UNION ALL SELECT * FROM $was_changed
    {% else %}
        SELECT
            id, id_type, cryptaId,
            [($generate_date_ts, CAST(cryptaId AS UInt64) ?? 0)] AS crypta_ids
        FROM $vertices_by_id_tbl
    {% endif %}
    ) ORDER BY id, id_type, cryptaId;

END DEFINE;

DEFINE ACTION $filter_active_profiles() AS

    $hisotry_profile = (
        SELECT
            1187 AS keyword,
            id, id_type, cryptaId,
            ListReverse(ListTake(ListReverse(crypta_ids), 10)) AS crypta_ids,
            Identifiers::ProfileUniq(id_type, id) AS UniqID
        FROM $cid_history_tbl
        WHERE
            cryptaId != "0"
            AND id_type IN {
                "yandexuid",
                "icookie",
                "puid",
                "idfa",
                "gaid",
                "oaid",
                "mm_device_id"
            }
            AND Identifiers::ProfileUniq(id_type, id) IS NOT NULL
    );

    INSERT INTO $cid_history_export WITH TRUNCATE
    SELECT cid.* FROM $hisotry_profile AS cid
    LEFT SEMI JOIN $profile_dump AS bb
    USING (UniqID)
    ORDER BY id, id_type, cryptaId;

END DEFINE;

DO $metrica_diff();
DO $crypta_id_change_history();

COMMIT;

DO $filter_active_profiles();
