from __future__ import print_function
import os

from crypta.lib.python.yql_runner.base_parser import BaseParser, timer, make_arg_parser


class YuidApps(BaseParser):

    """ Run YQL query to parse yuid apps """

    IDS_STORAGE_DIR = "//home/crypta/{crypta_env}/ids_storage"

    QUERY_TEMPLATE = "yuid_apps.sql.j2"

    def get_context_data(self, **kwargs):
        context = super(YuidApps, self).get_context_data(**kwargs)
        context.update(soup_dates_enabled=True)
        return context


@timer
def main():
    parser = make_arg_parser(description="Collect mobile apps for yuids")
    args = parser.parse_args()

    yuid_apps = YuidApps(
        date=args.date,
        yt_proxy=args.cluster,
        pool=args.pool,
        mrjob_binary=os.path.abspath(args.mrjob),
        udf_resolver_binary=os.path.abspath(args.udfr),
        udfs_dir=os.path.abspath(args.udfsdir),
        loglevel=args.loglevel,
        limit=args.limit,
        is_embedded=args.is_embedded,
    )
    assert yuid_apps.get_token(), "Env variable YT_TOKEN required!"
    if os.environ.get("VERBOSE"):
        print(yuid_apps.render_query())
    return yuid_apps.run()


if __name__ == "__main__":
    main()
