PRAGMA yt.MaxJobCount = '30000';

$date = '{{ date }}';
$parse_date = DateTime::Parse('%Y-%m-%d');

$yuid_puid = (
    select id1 as yuid, id2 as puid
    from `{{ graph_output_dir }}/v2/soup/yandexuid_puid_passport-auth_fp`
);

$yuid_devid = (
    SELECT id1 AS yuid, id2 AS devid
    FROM EACH(AsList(
        '{{ graph_output_dir }}/v2/soup/yandexuid_mm_device_id_watch-yp-did-ios_wl',
        '{{ graph_output_dir }}/v2/soup/yandexuid_mm_device_id_access-yp-did_access',
        '{{ graph_output_dir }}/v2/soup/yandexuid_mm_device_id_track_mob-tracking',
        '{{ graph_output_dir }}/v2/soup/yandexuid_mm_device_id_watch-yp-did-android_wl',
        '{{ graph_output_dir }}/v2/soup/yandexuid_mm_device_id_yabro-event_mm',
    ))
);

$yuid_uuid = (
    SELECT id1 AS yuid, id2 AS `uuid`
    FROM EACH(AsList(
        '{{ graph_output_dir }}/v2/soup/yandexuid_uuid_app-metrica-sdk_mobile-redir-bind',
        '{{ graph_output_dir }}/v2/soup/yandexuid_uuid_app-metrica-socket-android_wl',
        '{{ graph_output_dir }}/v2/soup/yandexuid_uuid_app-metrica-socket-ios_wl',
        '{{ graph_output_dir }}/v2/soup/yandexuid_uuid_app-url-redir_access',
        '{{ graph_output_dir }}/v2/soup/yandexuid_uuid_app-url-redir_redir',
        '{{ graph_output_dir }}/v2/soup/yandexuid_uuid_app-url-redir_wl',
        '{{ graph_output_dir }}/v2/soup/yandexuid_uuid_track_mob-tracking',
        '{{ graph_output_dir }}/v2/soup/yandexuid_uuid_idserv_idserv',
        '{{ graph_output_dir }}/v2/soup/yandexuid_uuid_search-app-startup_access',
        '{{ graph_output_dir }}/v2/soup/yandexuid_uuid_xuniq_xuniq',
        '{{ graph_output_dir }}/v2/soup/yandexuid_uuid_yabro-android_bar',
        '{{ graph_output_dir }}/v2/soup/yandexuid_uuid_yabro-ios_sbapi-lookup',
    ))

);

$yuid_idfa = (
    SELECT id1 AS yuid, id2 AS idfa
    FROM EACH(AsList(
        '{{ graph_output_dir }}/v2/soup/yandexuid_idfa_app-metrica-socket-ios_wl',
        '{{ graph_output_dir }}/v2/soup/yandexuid_idfa_app-install-tracker_metrica-postclick',
    ))
);

$yuid_oaid = (
    SELECT id1 AS yuid, id2 AS oaid
    FROM EACH(AsList(
        '{{ graph_output_dir }}/v2/soup/yandexuid_oaid_app-metrica-socket-android_wl',
        '{{ graph_output_dir }}/v2/soup/yandexuid_oaid_app-install-tracker_metrica-postclick',
    ))
);

$yuid_gaid = (
    SELECT id1 AS yuid, id2 AS gaid
    FROM EACH(AsList(
        '{{ graph_output_dir }}/v2/soup/yandexuid_gaid_app-metrica-socket-android_wl',
        '{{ graph_output_dir }}/v2/soup/yandexuid_gaid_app-install-tracker_metrica-postclick',
    ))
);

$puid_devid = (
    select id1 as puid, id2 as devid
    from `{{ graph_output_dir }}/v2/soup/puid_mm_device_id_app-auth_oauth`
);

$puid_uuid = (
    select id1 as puid, id2 as `uuid`
    from `{{ graph_output_dir }}/v2/soup/puid_uuid_app-auth_oauth`
);

$uuid_devid = (
    select id1 as devid, id2 as `uuid`
    from `{{ graph_output_dir }}/v2/soup/mm_device_id_uuid_app-metrica_mm`
);

$devid_idfa = (
    select id1 as idfa, id2 as devid
    from `{{ graph_output_dir }}/v2/soup/idfa_mm_device_id_app-metrica_mm`
);

$devid_oaid = (
    select id1 as oaid, id2 as devid
    from `{{ graph_output_dir }}/v2/soup/oaid_mm_device_id_app-metrica_mm`
);

$devid_gaid = (
    select id1 as gaid, id2 as devid
    from `{{ graph_output_dir }}/v2/soup/gaid_mm_device_id_app-metrica_mm`
);

$yuid_devid_all = (
    select distinct yuid, devid from (
        -- yuid - mm_devid
        select yuid, devid from $yuid_devid
        union all

        -- yuid - uuid - mm_devid
        select t1.yuid as yuid, t2.devid as devid
        from $yuid_uuid as t1 inner join
             $uuid_devid as t2 on t1.`uuid` = t2.`uuid`
        union all

        -- yuid - puid - mm_devid
        select t1.yuid as yuid, t2.devid as devid
        from $yuid_puid as t1 inner join
             $puid_devid as t2 on t1.puid = t2.puid
        union all

        -- yuid - puid - uuid - mm_devid
        select t1.yuid as yuid, t3.devid as devid
        from $yuid_puid as t1 inner join
             $puid_uuid as t2 on t1.puid = t2.puid inner join
             $uuid_devid as t3 on t2.`uuid` = t3.`uuid`
        union all

        -- yuid - idfa - mm_devid
        select t1.yuid as yuid, t2.devid as devid
        from $yuid_idfa as t1 inner join
             $devid_idfa as t2 on t1.idfa = t2.idfa
        union all

        -- yuid - oaid - mm_devid
        select t1.yuid as yuid, t2.devid as devid
        from $yuid_oaid as t1 inner join
             $devid_oaid as t2 on t1.oaid = t2.oaid
        union all

        -- yuid - gaid - mm_devid
        select t1.yuid as yuid, t2.devid as devid
        from $yuid_gaid as t1 inner join
             $devid_gaid as t2 on t1.gaid = t2.gaid
    )
);

$is_fresh = ($dtstr) -> {
    RETURN (
        DateTime::MakeTimestamp($parse_date($date)) -
        DateTime::MakeTimestamp($parse_date($dtstr))
    ) <= Interval('P100D');
};

$yuid_devid_good_ua = (
    SELECT a.yuid AS yuid, a.devid AS devid, String::ToLower(b.os_family) AS platform
    FROM $yuid_devid_all as a
    INNER JOIN `{{ ids_storage_dir }}/yandexuid/eternal` AS b ON a.yuid = b.id
    -- INNER JOIN `{{ ids_storage_dir }}/mm_device_id/eternal` AS c ON a.devid = c.id
    INNER JOIN $soup_dates('{{ graph_output_dir }}/v2/soup', 'mm_device_id') AS c ON a.devid = c.id
    WHERE $is_fresh(b.date_end)
        AND $is_fresh(c.date_end)
        -- AND String::ToLower(b.os_family) = String::ToLower(c.os)
);

$devids = (
    SELECT DISTINCT devid
    FROM $yuid_devid_good_ua
);

$is_yandex_app = ($app) -> {
    RETURN String::Contains($app, 'yandex') OR
           String::Contains($app, 'ru.auto') OR
           String::Contains($app, 'kinopoisk') OR
           String::Contains($app, 'edadeal');
};

$devid_apps = (
    SELECT a.devid AS devid, c.app_id AS app_id
    FROM $devids AS a
    INNER JOIN `{{ graph_output_dir }}/v2/soup/mm_device_id_uuid_app-metrica_mm` AS b ON a.devid = b.id1
    INNER JOIN `{{ ids_storage_dir }}/uuid/eternal` AS c ON b.id2 = c.id
    WHERE $is_yandex_app(c.app_id)
        AND $is_fresh(c.date_end)
);

$yuid_devid_good_ua_w = (
    SELECT devid, yuid, platform
    FROM (
        SELECT
            devid, yuid, platform,
            ROW_NUMBER() OVER W AS dev_rank 
        FROM $yuid_devid_good_ua
        WINDOW W AS (PARTITION BY yuid)
    ) WHERE dev_rank < 1000
    ORDER BY devid, yuid
);

$devid_apps_w = (
    SELECT devid, app_id
    FROM (
        SELECT
            devid, app_id,
            ROW_NUMBER() OVER W AS dev_rank 
        FROM $devid_apps
        WINDOW W AS (PARTITION BY devid)
    ) WHERE dev_rank < 1000
    ORDER BY devid, app_id
);

$yuid_apps = (
    SELECT a.yuid AS yuid, a.platform AS platform, b.app_id AS app_id
    FROM $yuid_devid_good_ua_w AS a
    INNER JOIN $devid_apps_w AS b ON a.devid = b.devid
);

$yuid_apps2 = (
    SELECT
        yuid, SOME(platform) AS platform,
        AGGREGATE_LIST_DISTINCT(app_id, 1000) AS apps
    FROM $yuid_apps
    GROUP BY yuid
);

INSERT INTO `{{ graph_output_dir }}/{{ date }}/yuid_apps` WITH truncate
SELECT * FROM $yuid_apps2
WHERE ListLength(apps) > 0;
