package ru.yandex.crypta.idm;

public class FieldDefinition {

    private final String slug;
    private final LocalizedString name;
    private final String type;
    private final boolean required;

    private FieldDefinition(String slug, LocalizedString name, String type, boolean required) {
        this.slug = slug;
        this.name = name;
        this.type = type;
        this.required = required;
    }

    public String getSlug() {
        return slug;
    }

    public LocalizedString getName() {
        return name;
    }

    public String getType() {
        return type;
    }

    public boolean isRequired() {
        return required;
    }

    public static FieldDefinition requiredCharfield(String slug, LocalizedString name) {
        return new FieldDefinition(slug, name, "charfield", true);
    }

}
